/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteApplicationInputProcessingConfigurationRequest extends KinesisAnalyticsRequest
        implements
        ToCopyableBuilder<DeleteApplicationInputProcessingConfigurationRequest.Builder, DeleteApplicationInputProcessingConfigurationRequest> {
    private final String applicationName;

    private final Long currentApplicationVersionId;

    private final String inputId;

    private DeleteApplicationInputProcessingConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.applicationName = builder.applicationName;
        this.currentApplicationVersionId = builder.currentApplicationVersionId;
        this.inputId = builder.inputId;
    }

    /**
     * <p>
     * The Kinesis Analytics application name.
     * </p>
     * 
     * @return The Kinesis Analytics application name.
     */
    public String applicationName() {
        return applicationName;
    }

    /**
     * <p>
     * The version ID of the Kinesis Analytics application.
     * </p>
     * 
     * @return The version ID of the Kinesis Analytics application.
     */
    public Long currentApplicationVersionId() {
        return currentApplicationVersionId;
    }

    /**
     * <p>
     * The ID of the input configuration from which to delete the input configuration. You can get a list of the input
     * IDs for an application using the <a>DescribeApplication</a> operation.
     * </p>
     * 
     * @return The ID of the input configuration from which to delete the input configuration. You can get a list of the
     *         input IDs for an application using the <a>DescribeApplication</a> operation.
     */
    public String inputId() {
        return inputId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(currentApplicationVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(inputId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteApplicationInputProcessingConfigurationRequest)) {
            return false;
        }
        DeleteApplicationInputProcessingConfigurationRequest other = (DeleteApplicationInputProcessingConfigurationRequest) obj;
        return Objects.equals(applicationName(), other.applicationName())
                && Objects.equals(currentApplicationVersionId(), other.currentApplicationVersionId())
                && Objects.equals(inputId(), other.inputId());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (applicationName() != null) {
            sb.append("ApplicationName: ").append(applicationName()).append(",");
        }
        if (currentApplicationVersionId() != null) {
            sb.append("CurrentApplicationVersionId: ").append(currentApplicationVersionId()).append(",");
        }
        if (inputId() != null) {
            sb.append("InputId: ").append(inputId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationName":
            return Optional.of(clazz.cast(applicationName()));
        case "CurrentApplicationVersionId":
            return Optional.of(clazz.cast(currentApplicationVersionId()));
        case "InputId":
            return Optional.of(clazz.cast(inputId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends KinesisAnalyticsRequest.Builder,
            CopyableBuilder<Builder, DeleteApplicationInputProcessingConfigurationRequest> {
        /**
         * <p>
         * The Kinesis Analytics application name.
         * </p>
         * 
         * @param applicationName
         *        The Kinesis Analytics application name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationName(String applicationName);

        /**
         * <p>
         * The version ID of the Kinesis Analytics application.
         * </p>
         * 
         * @param currentApplicationVersionId
         *        The version ID of the Kinesis Analytics application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentApplicationVersionId(Long currentApplicationVersionId);

        /**
         * <p>
         * The ID of the input configuration from which to delete the input configuration. You can get a list of the
         * input IDs for an application using the <a>DescribeApplication</a> operation.
         * </p>
         * 
         * @param inputId
         *        The ID of the input configuration from which to delete the input configuration. You can get a list of
         *        the input IDs for an application using the <a>DescribeApplication</a> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputId(String inputId);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends KinesisAnalyticsRequest.BuilderImpl implements Builder {
        private String applicationName;

        private Long currentApplicationVersionId;

        private String inputId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteApplicationInputProcessingConfigurationRequest model) {
            applicationName(model.applicationName);
            currentApplicationVersionId(model.currentApplicationVersionId);
            inputId(model.inputId);
        }

        public final String getApplicationName() {
            return applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final Long getCurrentApplicationVersionId() {
            return currentApplicationVersionId;
        }

        @Override
        public final Builder currentApplicationVersionId(Long currentApplicationVersionId) {
            this.currentApplicationVersionId = currentApplicationVersionId;
            return this;
        }

        public final void setCurrentApplicationVersionId(Long currentApplicationVersionId) {
            this.currentApplicationVersionId = currentApplicationVersionId;
        }

        public final String getInputId() {
            return inputId;
        }

        @Override
        public final Builder inputId(String inputId) {
            this.inputId = inputId;
            return this;
        }

        public final void setInputId(String inputId) {
            this.inputId = inputId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DeleteApplicationInputProcessingConfigurationRequest build() {
            return new DeleteApplicationInputProcessingConfigurationRequest(this);
        }
    }
}
