/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DiscoverInputSchemaRequest extends KinesisAnalyticsRequest implements
        ToCopyableBuilder<DiscoverInputSchemaRequest.Builder, DiscoverInputSchemaRequest> {
    private final String resourceARN;

    private final String roleARN;

    private final InputStartingPositionConfiguration inputStartingPositionConfiguration;

    private final S3Configuration s3Configuration;

    private final InputProcessingConfiguration inputProcessingConfiguration;

    private DiscoverInputSchemaRequest(BuilderImpl builder) {
        super(builder);
        this.resourceARN = builder.resourceARN;
        this.roleARN = builder.roleARN;
        this.inputStartingPositionConfiguration = builder.inputStartingPositionConfiguration;
        this.s3Configuration = builder.s3Configuration;
        this.inputProcessingConfiguration = builder.inputProcessingConfiguration;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of the streaming source.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of the streaming source.
     */
    public String resourceARN() {
        return resourceARN;
    }

    /**
     * <p>
     * ARN of the IAM role that Amazon Kinesis Analytics can assume to access the stream on your behalf.
     * </p>
     * 
     * @return ARN of the IAM role that Amazon Kinesis Analytics can assume to access the stream on your behalf.
     */
    public String roleARN() {
        return roleARN;
    }

    /**
     * <p>
     * Point at which you want Amazon Kinesis Analytics to start reading records from the specified streaming source
     * discovery purposes.
     * </p>
     * 
     * @return Point at which you want Amazon Kinesis Analytics to start reading records from the specified streaming
     *         source discovery purposes.
     */
    public InputStartingPositionConfiguration inputStartingPositionConfiguration() {
        return inputStartingPositionConfiguration;
    }

    /**
     * Returns the value of the S3Configuration property for this object.
     * 
     * @return The value of the S3Configuration property for this object.
     */
    public S3Configuration s3Configuration() {
        return s3Configuration;
    }

    /**
     * <p>
     * The <a>InputProcessingConfiguration</a> to use to preprocess the records before discovering the schema of the
     * records.
     * </p>
     * 
     * @return The <a>InputProcessingConfiguration</a> to use to preprocess the records before discovering the schema of
     *         the records.
     */
    public InputProcessingConfiguration inputProcessingConfiguration() {
        return inputProcessingConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceARN());
        hashCode = 31 * hashCode + Objects.hashCode(roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(inputStartingPositionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(s3Configuration());
        hashCode = 31 * hashCode + Objects.hashCode(inputProcessingConfiguration());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DiscoverInputSchemaRequest)) {
            return false;
        }
        DiscoverInputSchemaRequest other = (DiscoverInputSchemaRequest) obj;
        return Objects.equals(resourceARN(), other.resourceARN()) && Objects.equals(roleARN(), other.roleARN())
                && Objects.equals(inputStartingPositionConfiguration(), other.inputStartingPositionConfiguration())
                && Objects.equals(s3Configuration(), other.s3Configuration())
                && Objects.equals(inputProcessingConfiguration(), other.inputProcessingConfiguration());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (resourceARN() != null) {
            sb.append("ResourceARN: ").append(resourceARN()).append(",");
        }
        if (roleARN() != null) {
            sb.append("RoleARN: ").append(roleARN()).append(",");
        }
        if (inputStartingPositionConfiguration() != null) {
            sb.append("InputStartingPositionConfiguration: ").append(inputStartingPositionConfiguration()).append(",");
        }
        if (s3Configuration() != null) {
            sb.append("S3Configuration: ").append(s3Configuration()).append(",");
        }
        if (inputProcessingConfiguration() != null) {
            sb.append("InputProcessingConfiguration: ").append(inputProcessingConfiguration()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceARN":
            return Optional.of(clazz.cast(resourceARN()));
        case "RoleARN":
            return Optional.of(clazz.cast(roleARN()));
        case "InputStartingPositionConfiguration":
            return Optional.of(clazz.cast(inputStartingPositionConfiguration()));
        case "S3Configuration":
            return Optional.of(clazz.cast(s3Configuration()));
        case "InputProcessingConfiguration":
            return Optional.of(clazz.cast(inputProcessingConfiguration()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends KinesisAnalyticsRequest.Builder, CopyableBuilder<Builder, DiscoverInputSchemaRequest> {
        /**
         * <p>
         * Amazon Resource Name (ARN) of the streaming source.
         * </p>
         * 
         * @param resourceARN
         *        Amazon Resource Name (ARN) of the streaming source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceARN(String resourceARN);

        /**
         * <p>
         * ARN of the IAM role that Amazon Kinesis Analytics can assume to access the stream on your behalf.
         * </p>
         * 
         * @param roleARN
         *        ARN of the IAM role that Amazon Kinesis Analytics can assume to access the stream on your behalf.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleARN(String roleARN);

        /**
         * <p>
         * Point at which you want Amazon Kinesis Analytics to start reading records from the specified streaming source
         * discovery purposes.
         * </p>
         * 
         * @param inputStartingPositionConfiguration
         *        Point at which you want Amazon Kinesis Analytics to start reading records from the specified streaming
         *        source discovery purposes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputStartingPositionConfiguration(InputStartingPositionConfiguration inputStartingPositionConfiguration);

        /**
         * <p>
         * Point at which you want Amazon Kinesis Analytics to start reading records from the specified streaming source
         * discovery purposes.
         * </p>
         * This is a convenience that creates an instance of the {@link InputStartingPositionConfiguration.Builder}
         * avoiding the need to create one manually via {@link InputStartingPositionConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link InputStartingPositionConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #inputStartingPositionConfiguration(InputStartingPositionConfiguration)}.
         * 
         * @param inputStartingPositionConfiguration
         *        a consumer that will call methods on {@link InputStartingPositionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputStartingPositionConfiguration(InputStartingPositionConfiguration)
         */
        default Builder inputStartingPositionConfiguration(
                Consumer<InputStartingPositionConfiguration.Builder> inputStartingPositionConfiguration) {
            return inputStartingPositionConfiguration(InputStartingPositionConfiguration.builder()
                    .apply(inputStartingPositionConfiguration).build());
        }

        /**
         * Sets the value of the S3Configuration property for this object.
         *
         * @param s3Configuration
         *        The new value for the S3Configuration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Configuration(S3Configuration s3Configuration);

        /**
         * Sets the value of the S3Configuration property for this object.
         *
         * This is a convenience that creates an instance of the {@link S3Configuration.Builder} avoiding the need to
         * create one manually via {@link S3Configuration#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3Configuration.Builder#build()} is called immediately and its
         * result is passed to {@link #s3Configuration(S3Configuration)}.
         * 
         * @param s3Configuration
         *        a consumer that will call methods on {@link S3Configuration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Configuration(S3Configuration)
         */
        default Builder s3Configuration(Consumer<S3Configuration.Builder> s3Configuration) {
            return s3Configuration(S3Configuration.builder().apply(s3Configuration).build());
        }

        /**
         * <p>
         * The <a>InputProcessingConfiguration</a> to use to preprocess the records before discovering the schema of the
         * records.
         * </p>
         * 
         * @param inputProcessingConfiguration
         *        The <a>InputProcessingConfiguration</a> to use to preprocess the records before discovering the schema
         *        of the records.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputProcessingConfiguration(InputProcessingConfiguration inputProcessingConfiguration);

        /**
         * <p>
         * The <a>InputProcessingConfiguration</a> to use to preprocess the records before discovering the schema of the
         * records.
         * </p>
         * This is a convenience that creates an instance of the {@link InputProcessingConfiguration.Builder} avoiding
         * the need to create one manually via {@link InputProcessingConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link InputProcessingConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #inputProcessingConfiguration(InputProcessingConfiguration)}.
         * 
         * @param inputProcessingConfiguration
         *        a consumer that will call methods on {@link InputProcessingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputProcessingConfiguration(InputProcessingConfiguration)
         */
        default Builder inputProcessingConfiguration(Consumer<InputProcessingConfiguration.Builder> inputProcessingConfiguration) {
            return inputProcessingConfiguration(InputProcessingConfiguration.builder().apply(inputProcessingConfiguration)
                    .build());
        }

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends KinesisAnalyticsRequest.BuilderImpl implements Builder {
        private String resourceARN;

        private String roleARN;

        private InputStartingPositionConfiguration inputStartingPositionConfiguration;

        private S3Configuration s3Configuration;

        private InputProcessingConfiguration inputProcessingConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(DiscoverInputSchemaRequest model) {
            resourceARN(model.resourceARN);
            roleARN(model.roleARN);
            inputStartingPositionConfiguration(model.inputStartingPositionConfiguration);
            s3Configuration(model.s3Configuration);
            inputProcessingConfiguration(model.inputProcessingConfiguration);
        }

        public final String getResourceARN() {
            return resourceARN;
        }

        @Override
        public final Builder resourceARN(String resourceARN) {
            this.resourceARN = resourceARN;
            return this;
        }

        public final void setResourceARN(String resourceARN) {
            this.resourceARN = resourceARN;
        }

        public final String getRoleARN() {
            return roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public final InputStartingPositionConfiguration.Builder getInputStartingPositionConfiguration() {
            return inputStartingPositionConfiguration != null ? inputStartingPositionConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder inputStartingPositionConfiguration(
                InputStartingPositionConfiguration inputStartingPositionConfiguration) {
            this.inputStartingPositionConfiguration = inputStartingPositionConfiguration;
            return this;
        }

        public final void setInputStartingPositionConfiguration(
                InputStartingPositionConfiguration.BuilderImpl inputStartingPositionConfiguration) {
            this.inputStartingPositionConfiguration = inputStartingPositionConfiguration != null ? inputStartingPositionConfiguration
                    .build() : null;
        }

        public final S3Configuration.Builder getS3Configuration() {
            return s3Configuration != null ? s3Configuration.toBuilder() : null;
        }

        @Override
        public final Builder s3Configuration(S3Configuration s3Configuration) {
            this.s3Configuration = s3Configuration;
            return this;
        }

        public final void setS3Configuration(S3Configuration.BuilderImpl s3Configuration) {
            this.s3Configuration = s3Configuration != null ? s3Configuration.build() : null;
        }

        public final InputProcessingConfiguration.Builder getInputProcessingConfiguration() {
            return inputProcessingConfiguration != null ? inputProcessingConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder inputProcessingConfiguration(InputProcessingConfiguration inputProcessingConfiguration) {
            this.inputProcessingConfiguration = inputProcessingConfiguration;
            return this;
        }

        public final void setInputProcessingConfiguration(InputProcessingConfiguration.BuilderImpl inputProcessingConfiguration) {
            this.inputProcessingConfiguration = inputProcessingConfiguration != null ? inputProcessingConfiguration.build()
                    : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DiscoverInputSchemaRequest build() {
            return new DiscoverInputSchemaRequest(this);
        }
    }
}
