/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.transform.InputDescriptionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the application input configuration. For more information, see <a
 * href="http://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-input.html">Configuring Application
 * Input</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class InputDescription implements StructuredPojo, ToCopyableBuilder<InputDescription.Builder, InputDescription> {
    private final String inputId;

    private final String namePrefix;

    private final List<String> inAppStreamNames;

    private final InputProcessingConfigurationDescription inputProcessingConfigurationDescription;

    private final KinesisStreamsInputDescription kinesisStreamsInputDescription;

    private final KinesisFirehoseInputDescription kinesisFirehoseInputDescription;

    private final SourceSchema inputSchema;

    private final InputParallelism inputParallelism;

    private final InputStartingPositionConfiguration inputStartingPositionConfiguration;

    private InputDescription(BuilderImpl builder) {
        this.inputId = builder.inputId;
        this.namePrefix = builder.namePrefix;
        this.inAppStreamNames = builder.inAppStreamNames;
        this.inputProcessingConfigurationDescription = builder.inputProcessingConfigurationDescription;
        this.kinesisStreamsInputDescription = builder.kinesisStreamsInputDescription;
        this.kinesisFirehoseInputDescription = builder.kinesisFirehoseInputDescription;
        this.inputSchema = builder.inputSchema;
        this.inputParallelism = builder.inputParallelism;
        this.inputStartingPositionConfiguration = builder.inputStartingPositionConfiguration;
    }

    /**
     * <p>
     * Input ID associated with the application input. This is the ID that Amazon Kinesis Analytics assigns to each
     * input configuration you add to your application.
     * </p>
     * 
     * @return Input ID associated with the application input. This is the ID that Amazon Kinesis Analytics assigns to
     *         each input configuration you add to your application.
     */
    public String inputId() {
        return inputId;
    }

    /**
     * <p>
     * In-application name prefix.
     * </p>
     * 
     * @return In-application name prefix.
     */
    public String namePrefix() {
        return namePrefix;
    }

    /**
     * <p>
     * Returns the in-application stream names that are mapped to the stream source.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Returns the in-application stream names that are mapped to the stream source.
     */
    public List<String> inAppStreamNames() {
        return inAppStreamNames;
    }

    /**
     * <p>
     * The description of the preprocessor that executes on records in this input before the application's code is run.
     * </p>
     * 
     * @return The description of the preprocessor that executes on records in this input before the application's code
     *         is run.
     */
    public InputProcessingConfigurationDescription inputProcessingConfigurationDescription() {
        return inputProcessingConfigurationDescription;
    }

    /**
     * <p>
     * If an Amazon Kinesis stream is configured as streaming source, provides Amazon Kinesis stream's ARN and an IAM
     * role that enables Amazon Kinesis Analytics to access the stream on your behalf.
     * </p>
     * 
     * @return If an Amazon Kinesis stream is configured as streaming source, provides Amazon Kinesis stream's ARN and
     *         an IAM role that enables Amazon Kinesis Analytics to access the stream on your behalf.
     */
    public KinesisStreamsInputDescription kinesisStreamsInputDescription() {
        return kinesisStreamsInputDescription;
    }

    /**
     * <p>
     * If an Amazon Kinesis Firehose delivery stream is configured as a streaming source, provides the Firehose delivery
     * stream's Amazon Resource Name (ARN) and an IAM role that enables Amazon Kinesis Analytics to access the stream on
     * your behalf.
     * </p>
     * 
     * @return If an Amazon Kinesis Firehose delivery stream is configured as a streaming source, provides the Firehose
     *         delivery stream's Amazon Resource Name (ARN) and an IAM role that enables Amazon Kinesis Analytics to
     *         access the stream on your behalf.
     */
    public KinesisFirehoseInputDescription kinesisFirehoseInputDescription() {
        return kinesisFirehoseInputDescription;
    }

    /**
     * <p>
     * Describes the format of the data in the streaming source, and how each data element maps to corresponding columns
     * in the in-application stream that is being created.
     * </p>
     * 
     * @return Describes the format of the data in the streaming source, and how each data element maps to corresponding
     *         columns in the in-application stream that is being created.
     */
    public SourceSchema inputSchema() {
        return inputSchema;
    }

    /**
     * <p>
     * Describes the configured parallelism (number of in-application streams mapped to the streaming source).
     * </p>
     * 
     * @return Describes the configured parallelism (number of in-application streams mapped to the streaming source).
     */
    public InputParallelism inputParallelism() {
        return inputParallelism;
    }

    /**
     * <p>
     * Point at which the application is configured to read from the input stream.
     * </p>
     * 
     * @return Point at which the application is configured to read from the input stream.
     */
    public InputStartingPositionConfiguration inputStartingPositionConfiguration() {
        return inputStartingPositionConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(inputId());
        hashCode = 31 * hashCode + Objects.hashCode(namePrefix());
        hashCode = 31 * hashCode + Objects.hashCode(inAppStreamNames());
        hashCode = 31 * hashCode + Objects.hashCode(inputProcessingConfigurationDescription());
        hashCode = 31 * hashCode + Objects.hashCode(kinesisStreamsInputDescription());
        hashCode = 31 * hashCode + Objects.hashCode(kinesisFirehoseInputDescription());
        hashCode = 31 * hashCode + Objects.hashCode(inputSchema());
        hashCode = 31 * hashCode + Objects.hashCode(inputParallelism());
        hashCode = 31 * hashCode + Objects.hashCode(inputStartingPositionConfiguration());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputDescription)) {
            return false;
        }
        InputDescription other = (InputDescription) obj;
        return Objects.equals(inputId(), other.inputId()) && Objects.equals(namePrefix(), other.namePrefix())
                && Objects.equals(inAppStreamNames(), other.inAppStreamNames())
                && Objects.equals(inputProcessingConfigurationDescription(), other.inputProcessingConfigurationDescription())
                && Objects.equals(kinesisStreamsInputDescription(), other.kinesisStreamsInputDescription())
                && Objects.equals(kinesisFirehoseInputDescription(), other.kinesisFirehoseInputDescription())
                && Objects.equals(inputSchema(), other.inputSchema())
                && Objects.equals(inputParallelism(), other.inputParallelism())
                && Objects.equals(inputStartingPositionConfiguration(), other.inputStartingPositionConfiguration());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (inputId() != null) {
            sb.append("InputId: ").append(inputId()).append(",");
        }
        if (namePrefix() != null) {
            sb.append("NamePrefix: ").append(namePrefix()).append(",");
        }
        if (inAppStreamNames() != null) {
            sb.append("InAppStreamNames: ").append(inAppStreamNames()).append(",");
        }
        if (inputProcessingConfigurationDescription() != null) {
            sb.append("InputProcessingConfigurationDescription: ").append(inputProcessingConfigurationDescription()).append(",");
        }
        if (kinesisStreamsInputDescription() != null) {
            sb.append("KinesisStreamsInputDescription: ").append(kinesisStreamsInputDescription()).append(",");
        }
        if (kinesisFirehoseInputDescription() != null) {
            sb.append("KinesisFirehoseInputDescription: ").append(kinesisFirehoseInputDescription()).append(",");
        }
        if (inputSchema() != null) {
            sb.append("InputSchema: ").append(inputSchema()).append(",");
        }
        if (inputParallelism() != null) {
            sb.append("InputParallelism: ").append(inputParallelism()).append(",");
        }
        if (inputStartingPositionConfiguration() != null) {
            sb.append("InputStartingPositionConfiguration: ").append(inputStartingPositionConfiguration()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InputId":
            return Optional.of(clazz.cast(inputId()));
        case "NamePrefix":
            return Optional.of(clazz.cast(namePrefix()));
        case "InAppStreamNames":
            return Optional.of(clazz.cast(inAppStreamNames()));
        case "InputProcessingConfigurationDescription":
            return Optional.of(clazz.cast(inputProcessingConfigurationDescription()));
        case "KinesisStreamsInputDescription":
            return Optional.of(clazz.cast(kinesisStreamsInputDescription()));
        case "KinesisFirehoseInputDescription":
            return Optional.of(clazz.cast(kinesisFirehoseInputDescription()));
        case "InputSchema":
            return Optional.of(clazz.cast(inputSchema()));
        case "InputParallelism":
            return Optional.of(clazz.cast(inputParallelism()));
        case "InputStartingPositionConfiguration":
            return Optional.of(clazz.cast(inputStartingPositionConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InputDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, InputDescription> {
        /**
         * <p>
         * Input ID associated with the application input. This is the ID that Amazon Kinesis Analytics assigns to each
         * input configuration you add to your application.
         * </p>
         * 
         * @param inputId
         *        Input ID associated with the application input. This is the ID that Amazon Kinesis Analytics assigns
         *        to each input configuration you add to your application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputId(String inputId);

        /**
         * <p>
         * In-application name prefix.
         * </p>
         * 
         * @param namePrefix
         *        In-application name prefix.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namePrefix(String namePrefix);

        /**
         * <p>
         * Returns the in-application stream names that are mapped to the stream source.
         * </p>
         * 
         * @param inAppStreamNames
         *        Returns the in-application stream names that are mapped to the stream source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inAppStreamNames(Collection<String> inAppStreamNames);

        /**
         * <p>
         * Returns the in-application stream names that are mapped to the stream source.
         * </p>
         * 
         * @param inAppStreamNames
         *        Returns the in-application stream names that are mapped to the stream source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inAppStreamNames(String... inAppStreamNames);

        /**
         * <p>
         * The description of the preprocessor that executes on records in this input before the application's code is
         * run.
         * </p>
         * 
         * @param inputProcessingConfigurationDescription
         *        The description of the preprocessor that executes on records in this input before the application's
         *        code is run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputProcessingConfigurationDescription(
                InputProcessingConfigurationDescription inputProcessingConfigurationDescription);

        /**
         * <p>
         * The description of the preprocessor that executes on records in this input before the application's code is
         * run.
         * </p>
         * This is a convenience that creates an instance of the {@link InputProcessingConfigurationDescription.Builder}
         * avoiding the need to create one manually via {@link InputProcessingConfigurationDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link InputProcessingConfigurationDescription.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #inputProcessingConfigurationDescription(InputProcessingConfigurationDescription)}.
         * 
         * @param inputProcessingConfigurationDescription
         *        a consumer that will call methods on {@link InputProcessingConfigurationDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputProcessingConfigurationDescription(InputProcessingConfigurationDescription)
         */
        default Builder inputProcessingConfigurationDescription(
                Consumer<InputProcessingConfigurationDescription.Builder> inputProcessingConfigurationDescription) {
            return inputProcessingConfigurationDescription(InputProcessingConfigurationDescription.builder()
                    .apply(inputProcessingConfigurationDescription).build());
        }

        /**
         * <p>
         * If an Amazon Kinesis stream is configured as streaming source, provides Amazon Kinesis stream's ARN and an
         * IAM role that enables Amazon Kinesis Analytics to access the stream on your behalf.
         * </p>
         * 
         * @param kinesisStreamsInputDescription
         *        If an Amazon Kinesis stream is configured as streaming source, provides Amazon Kinesis stream's ARN
         *        and an IAM role that enables Amazon Kinesis Analytics to access the stream on your behalf.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kinesisStreamsInputDescription(KinesisStreamsInputDescription kinesisStreamsInputDescription);

        /**
         * <p>
         * If an Amazon Kinesis stream is configured as streaming source, provides Amazon Kinesis stream's ARN and an
         * IAM role that enables Amazon Kinesis Analytics to access the stream on your behalf.
         * </p>
         * This is a convenience that creates an instance of the {@link KinesisStreamsInputDescription.Builder} avoiding
         * the need to create one manually via {@link KinesisStreamsInputDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link KinesisStreamsInputDescription.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #kinesisStreamsInputDescription(KinesisStreamsInputDescription)}.
         * 
         * @param kinesisStreamsInputDescription
         *        a consumer that will call methods on {@link KinesisStreamsInputDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kinesisStreamsInputDescription(KinesisStreamsInputDescription)
         */
        default Builder kinesisStreamsInputDescription(
                Consumer<KinesisStreamsInputDescription.Builder> kinesisStreamsInputDescription) {
            return kinesisStreamsInputDescription(KinesisStreamsInputDescription.builder().apply(kinesisStreamsInputDescription)
                    .build());
        }

        /**
         * <p>
         * If an Amazon Kinesis Firehose delivery stream is configured as a streaming source, provides the Firehose
         * delivery stream's Amazon Resource Name (ARN) and an IAM role that enables Amazon Kinesis Analytics to access
         * the stream on your behalf.
         * </p>
         * 
         * @param kinesisFirehoseInputDescription
         *        If an Amazon Kinesis Firehose delivery stream is configured as a streaming source, provides the
         *        Firehose delivery stream's Amazon Resource Name (ARN) and an IAM role that enables Amazon Kinesis
         *        Analytics to access the stream on your behalf.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kinesisFirehoseInputDescription(KinesisFirehoseInputDescription kinesisFirehoseInputDescription);

        /**
         * <p>
         * If an Amazon Kinesis Firehose delivery stream is configured as a streaming source, provides the Firehose
         * delivery stream's Amazon Resource Name (ARN) and an IAM role that enables Amazon Kinesis Analytics to access
         * the stream on your behalf.
         * </p>
         * This is a convenience that creates an instance of the {@link KinesisFirehoseInputDescription.Builder}
         * avoiding the need to create one manually via {@link KinesisFirehoseInputDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link KinesisFirehoseInputDescription.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #kinesisFirehoseInputDescription(KinesisFirehoseInputDescription)}.
         * 
         * @param kinesisFirehoseInputDescription
         *        a consumer that will call methods on {@link KinesisFirehoseInputDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kinesisFirehoseInputDescription(KinesisFirehoseInputDescription)
         */
        default Builder kinesisFirehoseInputDescription(
                Consumer<KinesisFirehoseInputDescription.Builder> kinesisFirehoseInputDescription) {
            return kinesisFirehoseInputDescription(KinesisFirehoseInputDescription.builder()
                    .apply(kinesisFirehoseInputDescription).build());
        }

        /**
         * <p>
         * Describes the format of the data in the streaming source, and how each data element maps to corresponding
         * columns in the in-application stream that is being created.
         * </p>
         * 
         * @param inputSchema
         *        Describes the format of the data in the streaming source, and how each data element maps to
         *        corresponding columns in the in-application stream that is being created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputSchema(SourceSchema inputSchema);

        /**
         * <p>
         * Describes the format of the data in the streaming source, and how each data element maps to corresponding
         * columns in the in-application stream that is being created.
         * </p>
         * This is a convenience that creates an instance of the {@link SourceSchema.Builder} avoiding the need to
         * create one manually via {@link SourceSchema#builder()}.
         *
         * When the {@link Consumer} completes, {@link SourceSchema.Builder#build()} is called immediately and its
         * result is passed to {@link #inputSchema(SourceSchema)}.
         * 
         * @param inputSchema
         *        a consumer that will call methods on {@link SourceSchema.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputSchema(SourceSchema)
         */
        default Builder inputSchema(Consumer<SourceSchema.Builder> inputSchema) {
            return inputSchema(SourceSchema.builder().apply(inputSchema).build());
        }

        /**
         * <p>
         * Describes the configured parallelism (number of in-application streams mapped to the streaming source).
         * </p>
         * 
         * @param inputParallelism
         *        Describes the configured parallelism (number of in-application streams mapped to the streaming
         *        source).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputParallelism(InputParallelism inputParallelism);

        /**
         * <p>
         * Describes the configured parallelism (number of in-application streams mapped to the streaming source).
         * </p>
         * This is a convenience that creates an instance of the {@link InputParallelism.Builder} avoiding the need to
         * create one manually via {@link InputParallelism#builder()}.
         *
         * When the {@link Consumer} completes, {@link InputParallelism.Builder#build()} is called immediately and its
         * result is passed to {@link #inputParallelism(InputParallelism)}.
         * 
         * @param inputParallelism
         *        a consumer that will call methods on {@link InputParallelism.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputParallelism(InputParallelism)
         */
        default Builder inputParallelism(Consumer<InputParallelism.Builder> inputParallelism) {
            return inputParallelism(InputParallelism.builder().apply(inputParallelism).build());
        }

        /**
         * <p>
         * Point at which the application is configured to read from the input stream.
         * </p>
         * 
         * @param inputStartingPositionConfiguration
         *        Point at which the application is configured to read from the input stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputStartingPositionConfiguration(InputStartingPositionConfiguration inputStartingPositionConfiguration);

        /**
         * <p>
         * Point at which the application is configured to read from the input stream.
         * </p>
         * This is a convenience that creates an instance of the {@link InputStartingPositionConfiguration.Builder}
         * avoiding the need to create one manually via {@link InputStartingPositionConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link InputStartingPositionConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #inputStartingPositionConfiguration(InputStartingPositionConfiguration)}.
         * 
         * @param inputStartingPositionConfiguration
         *        a consumer that will call methods on {@link InputStartingPositionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputStartingPositionConfiguration(InputStartingPositionConfiguration)
         */
        default Builder inputStartingPositionConfiguration(
                Consumer<InputStartingPositionConfiguration.Builder> inputStartingPositionConfiguration) {
            return inputStartingPositionConfiguration(InputStartingPositionConfiguration.builder()
                    .apply(inputStartingPositionConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String inputId;

        private String namePrefix;

        private List<String> inAppStreamNames;

        private InputProcessingConfigurationDescription inputProcessingConfigurationDescription;

        private KinesisStreamsInputDescription kinesisStreamsInputDescription;

        private KinesisFirehoseInputDescription kinesisFirehoseInputDescription;

        private SourceSchema inputSchema;

        private InputParallelism inputParallelism;

        private InputStartingPositionConfiguration inputStartingPositionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(InputDescription model) {
            inputId(model.inputId);
            namePrefix(model.namePrefix);
            inAppStreamNames(model.inAppStreamNames);
            inputProcessingConfigurationDescription(model.inputProcessingConfigurationDescription);
            kinesisStreamsInputDescription(model.kinesisStreamsInputDescription);
            kinesisFirehoseInputDescription(model.kinesisFirehoseInputDescription);
            inputSchema(model.inputSchema);
            inputParallelism(model.inputParallelism);
            inputStartingPositionConfiguration(model.inputStartingPositionConfiguration);
        }

        public final String getInputId() {
            return inputId;
        }

        @Override
        public final Builder inputId(String inputId) {
            this.inputId = inputId;
            return this;
        }

        public final void setInputId(String inputId) {
            this.inputId = inputId;
        }

        public final String getNamePrefix() {
            return namePrefix;
        }

        @Override
        public final Builder namePrefix(String namePrefix) {
            this.namePrefix = namePrefix;
            return this;
        }

        public final void setNamePrefix(String namePrefix) {
            this.namePrefix = namePrefix;
        }

        public final Collection<String> getInAppStreamNames() {
            return inAppStreamNames;
        }

        @Override
        public final Builder inAppStreamNames(Collection<String> inAppStreamNames) {
            this.inAppStreamNames = InAppStreamNamesCopier.copy(inAppStreamNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inAppStreamNames(String... inAppStreamNames) {
            inAppStreamNames(Arrays.asList(inAppStreamNames));
            return this;
        }

        public final void setInAppStreamNames(Collection<String> inAppStreamNames) {
            this.inAppStreamNames = InAppStreamNamesCopier.copy(inAppStreamNames);
        }

        public final InputProcessingConfigurationDescription.Builder getInputProcessingConfigurationDescription() {
            return inputProcessingConfigurationDescription != null ? inputProcessingConfigurationDescription.toBuilder() : null;
        }

        @Override
        public final Builder inputProcessingConfigurationDescription(
                InputProcessingConfigurationDescription inputProcessingConfigurationDescription) {
            this.inputProcessingConfigurationDescription = inputProcessingConfigurationDescription;
            return this;
        }

        public final void setInputProcessingConfigurationDescription(
                InputProcessingConfigurationDescription.BuilderImpl inputProcessingConfigurationDescription) {
            this.inputProcessingConfigurationDescription = inputProcessingConfigurationDescription != null ? inputProcessingConfigurationDescription
                    .build() : null;
        }

        public final KinesisStreamsInputDescription.Builder getKinesisStreamsInputDescription() {
            return kinesisStreamsInputDescription != null ? kinesisStreamsInputDescription.toBuilder() : null;
        }

        @Override
        public final Builder kinesisStreamsInputDescription(KinesisStreamsInputDescription kinesisStreamsInputDescription) {
            this.kinesisStreamsInputDescription = kinesisStreamsInputDescription;
            return this;
        }

        public final void setKinesisStreamsInputDescription(
                KinesisStreamsInputDescription.BuilderImpl kinesisStreamsInputDescription) {
            this.kinesisStreamsInputDescription = kinesisStreamsInputDescription != null ? kinesisStreamsInputDescription.build()
                    : null;
        }

        public final KinesisFirehoseInputDescription.Builder getKinesisFirehoseInputDescription() {
            return kinesisFirehoseInputDescription != null ? kinesisFirehoseInputDescription.toBuilder() : null;
        }

        @Override
        public final Builder kinesisFirehoseInputDescription(KinesisFirehoseInputDescription kinesisFirehoseInputDescription) {
            this.kinesisFirehoseInputDescription = kinesisFirehoseInputDescription;
            return this;
        }

        public final void setKinesisFirehoseInputDescription(
                KinesisFirehoseInputDescription.BuilderImpl kinesisFirehoseInputDescription) {
            this.kinesisFirehoseInputDescription = kinesisFirehoseInputDescription != null ? kinesisFirehoseInputDescription
                    .build() : null;
        }

        public final SourceSchema.Builder getInputSchema() {
            return inputSchema != null ? inputSchema.toBuilder() : null;
        }

        @Override
        public final Builder inputSchema(SourceSchema inputSchema) {
            this.inputSchema = inputSchema;
            return this;
        }

        public final void setInputSchema(SourceSchema.BuilderImpl inputSchema) {
            this.inputSchema = inputSchema != null ? inputSchema.build() : null;
        }

        public final InputParallelism.Builder getInputParallelism() {
            return inputParallelism != null ? inputParallelism.toBuilder() : null;
        }

        @Override
        public final Builder inputParallelism(InputParallelism inputParallelism) {
            this.inputParallelism = inputParallelism;
            return this;
        }

        public final void setInputParallelism(InputParallelism.BuilderImpl inputParallelism) {
            this.inputParallelism = inputParallelism != null ? inputParallelism.build() : null;
        }

        public final InputStartingPositionConfiguration.Builder getInputStartingPositionConfiguration() {
            return inputStartingPositionConfiguration != null ? inputStartingPositionConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder inputStartingPositionConfiguration(
                InputStartingPositionConfiguration inputStartingPositionConfiguration) {
            this.inputStartingPositionConfiguration = inputStartingPositionConfiguration;
            return this;
        }

        public final void setInputStartingPositionConfiguration(
                InputStartingPositionConfiguration.BuilderImpl inputStartingPositionConfiguration) {
            this.inputStartingPositionConfiguration = inputStartingPositionConfiguration != null ? inputStartingPositionConfiguration
                    .build() : null;
        }

        @Override
        public InputDescription build() {
            return new InputDescription(this);
        }
    }
}
