/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.transform.KinesisStreamsOutputMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * When configuring application output, identifies a Amazon Kinesis stream as the destination. You provide the stream
 * Amazon Resource Name (ARN) and also an IAM role ARN that Amazon Kinesis Analytics can use to write to the stream on
 * your behalf.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class KinesisStreamsOutput implements StructuredPojo,
        ToCopyableBuilder<KinesisStreamsOutput.Builder, KinesisStreamsOutput> {
    private final String resourceARN;

    private final String roleARN;

    private KinesisStreamsOutput(BuilderImpl builder) {
        this.resourceARN = builder.resourceARN;
        this.roleARN = builder.roleARN;
    }

    /**
     * <p>
     * ARN of the destination Amazon Kinesis stream to write to.
     * </p>
     * 
     * @return ARN of the destination Amazon Kinesis stream to write to.
     */
    public String resourceARN() {
        return resourceARN;
    }

    /**
     * <p>
     * ARN of the IAM role that Amazon Kinesis Analytics can assume to write to the destination stream on your behalf.
     * You need to grant the necessary permissions to this role.
     * </p>
     * 
     * @return ARN of the IAM role that Amazon Kinesis Analytics can assume to write to the destination stream on your
     *         behalf. You need to grant the necessary permissions to this role.
     */
    public String roleARN() {
        return roleARN;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceARN());
        hashCode = 31 * hashCode + Objects.hashCode(roleARN());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KinesisStreamsOutput)) {
            return false;
        }
        KinesisStreamsOutput other = (KinesisStreamsOutput) obj;
        return Objects.equals(resourceARN(), other.resourceARN()) && Objects.equals(roleARN(), other.roleARN());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (resourceARN() != null) {
            sb.append("ResourceARN: ").append(resourceARN()).append(",");
        }
        if (roleARN() != null) {
            sb.append("RoleARN: ").append(roleARN()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceARN":
            return Optional.of(clazz.cast(resourceARN()));
        case "RoleARN":
            return Optional.of(clazz.cast(roleARN()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        KinesisStreamsOutputMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, KinesisStreamsOutput> {
        /**
         * <p>
         * ARN of the destination Amazon Kinesis stream to write to.
         * </p>
         * 
         * @param resourceARN
         *        ARN of the destination Amazon Kinesis stream to write to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceARN(String resourceARN);

        /**
         * <p>
         * ARN of the IAM role that Amazon Kinesis Analytics can assume to write to the destination stream on your
         * behalf. You need to grant the necessary permissions to this role.
         * </p>
         * 
         * @param roleARN
         *        ARN of the IAM role that Amazon Kinesis Analytics can assume to write to the destination stream on
         *        your behalf. You need to grant the necessary permissions to this role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleARN(String roleARN);
    }

    static final class BuilderImpl implements Builder {
        private String resourceARN;

        private String roleARN;

        private BuilderImpl() {
        }

        private BuilderImpl(KinesisStreamsOutput model) {
            resourceARN(model.resourceARN);
            roleARN(model.roleARN);
        }

        public final String getResourceARN() {
            return resourceARN;
        }

        @Override
        public final Builder resourceARN(String resourceARN) {
            this.resourceARN = resourceARN;
            return this;
        }

        public final void setResourceARN(String resourceARN) {
            this.resourceARN = resourceARN;
        }

        public final String getRoleARN() {
            return roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        @Override
        public KinesisStreamsOutput build() {
            return new KinesisStreamsOutput(this);
        }
    }
}
