/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListApplicationsResponse extends KinesisAnalyticsResponse implements
        ToCopyableBuilder<ListApplicationsResponse.Builder, ListApplicationsResponse> {
    private final List<ApplicationSummary> applicationSummaries;

    private final Boolean hasMoreApplications;

    private ListApplicationsResponse(BuilderImpl builder) {
        super(builder);
        this.applicationSummaries = builder.applicationSummaries;
        this.hasMoreApplications = builder.hasMoreApplications;
    }

    /**
     * <p>
     * List of <code>ApplicationSummary</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return List of <code>ApplicationSummary</code> objects.
     */
    public List<ApplicationSummary> applicationSummaries() {
        return applicationSummaries;
    }

    /**
     * <p>
     * Returns true if there are more applications to retrieve.
     * </p>
     * 
     * @return Returns true if there are more applications to retrieve.
     */
    public Boolean hasMoreApplications() {
        return hasMoreApplications;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationSummaries());
        hashCode = 31 * hashCode + Objects.hashCode(hasMoreApplications());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListApplicationsResponse)) {
            return false;
        }
        ListApplicationsResponse other = (ListApplicationsResponse) obj;
        return Objects.equals(applicationSummaries(), other.applicationSummaries())
                && Objects.equals(hasMoreApplications(), other.hasMoreApplications());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (applicationSummaries() != null) {
            sb.append("ApplicationSummaries: ").append(applicationSummaries()).append(",");
        }
        if (hasMoreApplications() != null) {
            sb.append("HasMoreApplications: ").append(hasMoreApplications()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationSummaries":
            return Optional.of(clazz.cast(applicationSummaries()));
        case "HasMoreApplications":
            return Optional.of(clazz.cast(hasMoreApplications()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends KinesisAnalyticsResponse.Builder, CopyableBuilder<Builder, ListApplicationsResponse> {
        /**
         * <p>
         * List of <code>ApplicationSummary</code> objects.
         * </p>
         * 
         * @param applicationSummaries
         *        List of <code>ApplicationSummary</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationSummaries(Collection<ApplicationSummary> applicationSummaries);

        /**
         * <p>
         * List of <code>ApplicationSummary</code> objects.
         * </p>
         * 
         * @param applicationSummaries
         *        List of <code>ApplicationSummary</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationSummaries(ApplicationSummary... applicationSummaries);

        /**
         * <p>
         * Returns true if there are more applications to retrieve.
         * </p>
         * 
         * @param hasMoreApplications
         *        Returns true if there are more applications to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hasMoreApplications(Boolean hasMoreApplications);
    }

    static final class BuilderImpl extends KinesisAnalyticsResponse.BuilderImpl implements Builder {
        private List<ApplicationSummary> applicationSummaries;

        private Boolean hasMoreApplications;

        private BuilderImpl() {
        }

        private BuilderImpl(ListApplicationsResponse model) {
            applicationSummaries(model.applicationSummaries);
            hasMoreApplications(model.hasMoreApplications);
        }

        public final Collection<ApplicationSummary.Builder> getApplicationSummaries() {
            return applicationSummaries != null ? applicationSummaries.stream().map(ApplicationSummary::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder applicationSummaries(Collection<ApplicationSummary> applicationSummaries) {
            this.applicationSummaries = ApplicationSummariesCopier.copy(applicationSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationSummaries(ApplicationSummary... applicationSummaries) {
            applicationSummaries(Arrays.asList(applicationSummaries));
            return this;
        }

        public final void setApplicationSummaries(Collection<ApplicationSummary.BuilderImpl> applicationSummaries) {
            this.applicationSummaries = ApplicationSummariesCopier.copyFromBuilder(applicationSummaries);
        }

        public final Boolean getHasMoreApplications() {
            return hasMoreApplications;
        }

        @Override
        public final Builder hasMoreApplications(Boolean hasMoreApplications) {
            this.hasMoreApplications = hasMoreApplications;
            return this;
        }

        public final void setHasMoreApplications(Boolean hasMoreApplications) {
            this.hasMoreApplications = hasMoreApplications;
        }

        @Override
        public ListApplicationsResponse build() {
            return new ListApplicationsResponse(this);
        }
    }
}
