/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.transform.OutputDescriptionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the application output configuration, which includes the in-application stream name and the destination
 * where the stream data is written. The destination can be an Amazon Kinesis stream or an Amazon Kinesis Firehose
 * delivery stream.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class OutputDescription implements StructuredPojo, ToCopyableBuilder<OutputDescription.Builder, OutputDescription> {
    private final String outputId;

    private final String name;

    private final KinesisStreamsOutputDescription kinesisStreamsOutputDescription;

    private final KinesisFirehoseOutputDescription kinesisFirehoseOutputDescription;

    private final DestinationSchema destinationSchema;

    private OutputDescription(BuilderImpl builder) {
        this.outputId = builder.outputId;
        this.name = builder.name;
        this.kinesisStreamsOutputDescription = builder.kinesisStreamsOutputDescription;
        this.kinesisFirehoseOutputDescription = builder.kinesisFirehoseOutputDescription;
        this.destinationSchema = builder.destinationSchema;
    }

    /**
     * <p>
     * A unique identifier for the output configuration.
     * </p>
     * 
     * @return A unique identifier for the output configuration.
     */
    public String outputId() {
        return outputId;
    }

    /**
     * <p>
     * Name of the in-application stream configured as output.
     * </p>
     * 
     * @return Name of the in-application stream configured as output.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * Describes Amazon Kinesis stream configured as the destination where output is written.
     * </p>
     * 
     * @return Describes Amazon Kinesis stream configured as the destination where output is written.
     */
    public KinesisStreamsOutputDescription kinesisStreamsOutputDescription() {
        return kinesisStreamsOutputDescription;
    }

    /**
     * <p>
     * Describes the Amazon Kinesis Firehose delivery stream configured as the destination where output is written.
     * </p>
     * 
     * @return Describes the Amazon Kinesis Firehose delivery stream configured as the destination where output is
     *         written.
     */
    public KinesisFirehoseOutputDescription kinesisFirehoseOutputDescription() {
        return kinesisFirehoseOutputDescription;
    }

    /**
     * <p>
     * Data format used for writing data to the destination.
     * </p>
     * 
     * @return Data format used for writing data to the destination.
     */
    public DestinationSchema destinationSchema() {
        return destinationSchema;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(outputId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(kinesisStreamsOutputDescription());
        hashCode = 31 * hashCode + Objects.hashCode(kinesisFirehoseOutputDescription());
        hashCode = 31 * hashCode + Objects.hashCode(destinationSchema());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutputDescription)) {
            return false;
        }
        OutputDescription other = (OutputDescription) obj;
        return Objects.equals(outputId(), other.outputId()) && Objects.equals(name(), other.name())
                && Objects.equals(kinesisStreamsOutputDescription(), other.kinesisStreamsOutputDescription())
                && Objects.equals(kinesisFirehoseOutputDescription(), other.kinesisFirehoseOutputDescription())
                && Objects.equals(destinationSchema(), other.destinationSchema());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (outputId() != null) {
            sb.append("OutputId: ").append(outputId()).append(",");
        }
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (kinesisStreamsOutputDescription() != null) {
            sb.append("KinesisStreamsOutputDescription: ").append(kinesisStreamsOutputDescription()).append(",");
        }
        if (kinesisFirehoseOutputDescription() != null) {
            sb.append("KinesisFirehoseOutputDescription: ").append(kinesisFirehoseOutputDescription()).append(",");
        }
        if (destinationSchema() != null) {
            sb.append("DestinationSchema: ").append(destinationSchema()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OutputId":
            return Optional.of(clazz.cast(outputId()));
        case "Name":
            return Optional.of(clazz.cast(name()));
        case "KinesisStreamsOutputDescription":
            return Optional.of(clazz.cast(kinesisStreamsOutputDescription()));
        case "KinesisFirehoseOutputDescription":
            return Optional.of(clazz.cast(kinesisFirehoseOutputDescription()));
        case "DestinationSchema":
            return Optional.of(clazz.cast(destinationSchema()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        OutputDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, OutputDescription> {
        /**
         * <p>
         * A unique identifier for the output configuration.
         * </p>
         * 
         * @param outputId
         *        A unique identifier for the output configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputId(String outputId);

        /**
         * <p>
         * Name of the in-application stream configured as output.
         * </p>
         * 
         * @param name
         *        Name of the in-application stream configured as output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Describes Amazon Kinesis stream configured as the destination where output is written.
         * </p>
         * 
         * @param kinesisStreamsOutputDescription
         *        Describes Amazon Kinesis stream configured as the destination where output is written.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kinesisStreamsOutputDescription(KinesisStreamsOutputDescription kinesisStreamsOutputDescription);

        /**
         * <p>
         * Describes Amazon Kinesis stream configured as the destination where output is written.
         * </p>
         * This is a convenience that creates an instance of the {@link KinesisStreamsOutputDescription.Builder}
         * avoiding the need to create one manually via {@link KinesisStreamsOutputDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link KinesisStreamsOutputDescription.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #kinesisStreamsOutputDescription(KinesisStreamsOutputDescription)}.
         * 
         * @param kinesisStreamsOutputDescription
         *        a consumer that will call methods on {@link KinesisStreamsOutputDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kinesisStreamsOutputDescription(KinesisStreamsOutputDescription)
         */
        default Builder kinesisStreamsOutputDescription(
                Consumer<KinesisStreamsOutputDescription.Builder> kinesisStreamsOutputDescription) {
            return kinesisStreamsOutputDescription(KinesisStreamsOutputDescription.builder()
                    .apply(kinesisStreamsOutputDescription).build());
        }

        /**
         * <p>
         * Describes the Amazon Kinesis Firehose delivery stream configured as the destination where output is written.
         * </p>
         * 
         * @param kinesisFirehoseOutputDescription
         *        Describes the Amazon Kinesis Firehose delivery stream configured as the destination where output is
         *        written.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kinesisFirehoseOutputDescription(KinesisFirehoseOutputDescription kinesisFirehoseOutputDescription);

        /**
         * <p>
         * Describes the Amazon Kinesis Firehose delivery stream configured as the destination where output is written.
         * </p>
         * This is a convenience that creates an instance of the {@link KinesisFirehoseOutputDescription.Builder}
         * avoiding the need to create one manually via {@link KinesisFirehoseOutputDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link KinesisFirehoseOutputDescription.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #kinesisFirehoseOutputDescription(KinesisFirehoseOutputDescription)}.
         * 
         * @param kinesisFirehoseOutputDescription
         *        a consumer that will call methods on {@link KinesisFirehoseOutputDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kinesisFirehoseOutputDescription(KinesisFirehoseOutputDescription)
         */
        default Builder kinesisFirehoseOutputDescription(
                Consumer<KinesisFirehoseOutputDescription.Builder> kinesisFirehoseOutputDescription) {
            return kinesisFirehoseOutputDescription(KinesisFirehoseOutputDescription.builder()
                    .apply(kinesisFirehoseOutputDescription).build());
        }

        /**
         * <p>
         * Data format used for writing data to the destination.
         * </p>
         * 
         * @param destinationSchema
         *        Data format used for writing data to the destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationSchema(DestinationSchema destinationSchema);

        /**
         * <p>
         * Data format used for writing data to the destination.
         * </p>
         * This is a convenience that creates an instance of the {@link DestinationSchema.Builder} avoiding the need to
         * create one manually via {@link DestinationSchema#builder()}.
         *
         * When the {@link Consumer} completes, {@link DestinationSchema.Builder#build()} is called immediately and its
         * result is passed to {@link #destinationSchema(DestinationSchema)}.
         * 
         * @param destinationSchema
         *        a consumer that will call methods on {@link DestinationSchema.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationSchema(DestinationSchema)
         */
        default Builder destinationSchema(Consumer<DestinationSchema.Builder> destinationSchema) {
            return destinationSchema(DestinationSchema.builder().apply(destinationSchema).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String outputId;

        private String name;

        private KinesisStreamsOutputDescription kinesisStreamsOutputDescription;

        private KinesisFirehoseOutputDescription kinesisFirehoseOutputDescription;

        private DestinationSchema destinationSchema;

        private BuilderImpl() {
        }

        private BuilderImpl(OutputDescription model) {
            outputId(model.outputId);
            name(model.name);
            kinesisStreamsOutputDescription(model.kinesisStreamsOutputDescription);
            kinesisFirehoseOutputDescription(model.kinesisFirehoseOutputDescription);
            destinationSchema(model.destinationSchema);
        }

        public final String getOutputId() {
            return outputId;
        }

        @Override
        public final Builder outputId(String outputId) {
            this.outputId = outputId;
            return this;
        }

        public final void setOutputId(String outputId) {
            this.outputId = outputId;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final KinesisStreamsOutputDescription.Builder getKinesisStreamsOutputDescription() {
            return kinesisStreamsOutputDescription != null ? kinesisStreamsOutputDescription.toBuilder() : null;
        }

        @Override
        public final Builder kinesisStreamsOutputDescription(KinesisStreamsOutputDescription kinesisStreamsOutputDescription) {
            this.kinesisStreamsOutputDescription = kinesisStreamsOutputDescription;
            return this;
        }

        public final void setKinesisStreamsOutputDescription(
                KinesisStreamsOutputDescription.BuilderImpl kinesisStreamsOutputDescription) {
            this.kinesisStreamsOutputDescription = kinesisStreamsOutputDescription != null ? kinesisStreamsOutputDescription
                    .build() : null;
        }

        public final KinesisFirehoseOutputDescription.Builder getKinesisFirehoseOutputDescription() {
            return kinesisFirehoseOutputDescription != null ? kinesisFirehoseOutputDescription.toBuilder() : null;
        }

        @Override
        public final Builder kinesisFirehoseOutputDescription(KinesisFirehoseOutputDescription kinesisFirehoseOutputDescription) {
            this.kinesisFirehoseOutputDescription = kinesisFirehoseOutputDescription;
            return this;
        }

        public final void setKinesisFirehoseOutputDescription(
                KinesisFirehoseOutputDescription.BuilderImpl kinesisFirehoseOutputDescription) {
            this.kinesisFirehoseOutputDescription = kinesisFirehoseOutputDescription != null ? kinesisFirehoseOutputDescription
                    .build() : null;
        }

        public final DestinationSchema.Builder getDestinationSchema() {
            return destinationSchema != null ? destinationSchema.toBuilder() : null;
        }

        @Override
        public final Builder destinationSchema(DestinationSchema destinationSchema) {
            this.destinationSchema = destinationSchema;
            return this;
        }

        public final void setDestinationSchema(DestinationSchema.BuilderImpl destinationSchema) {
            this.destinationSchema = destinationSchema != null ? destinationSchema.build() : null;
        }

        @Override
        public OutputDescription build() {
            return new OutputDescription(this);
        }
    }
}
