/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.transform.ReferenceDataSourceMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the reference data source by providing the source information (S3 bucket name and object key name), the
 * resulting in-application table name that is created, and the necessary schema to map the data elements in the Amazon
 * S3 object to the in-application table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ReferenceDataSource implements StructuredPojo, ToCopyableBuilder<ReferenceDataSource.Builder, ReferenceDataSource> {
    private final String tableName;

    private final S3ReferenceDataSource s3ReferenceDataSource;

    private final SourceSchema referenceSchema;

    private ReferenceDataSource(BuilderImpl builder) {
        this.tableName = builder.tableName;
        this.s3ReferenceDataSource = builder.s3ReferenceDataSource;
        this.referenceSchema = builder.referenceSchema;
    }

    /**
     * <p>
     * Name of the in-application table to create.
     * </p>
     * 
     * @return Name of the in-application table to create.
     */
    public String tableName() {
        return tableName;
    }

    /**
     * Returns the value of the S3ReferenceDataSource property for this object.
     * 
     * @return The value of the S3ReferenceDataSource property for this object.
     */
    public S3ReferenceDataSource s3ReferenceDataSource() {
        return s3ReferenceDataSource;
    }

    /**
     * Returns the value of the ReferenceSchema property for this object.
     * 
     * @return The value of the ReferenceSchema property for this object.
     */
    public SourceSchema referenceSchema() {
        return referenceSchema;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        hashCode = 31 * hashCode + Objects.hashCode(s3ReferenceDataSource());
        hashCode = 31 * hashCode + Objects.hashCode(referenceSchema());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReferenceDataSource)) {
            return false;
        }
        ReferenceDataSource other = (ReferenceDataSource) obj;
        return Objects.equals(tableName(), other.tableName())
                && Objects.equals(s3ReferenceDataSource(), other.s3ReferenceDataSource())
                && Objects.equals(referenceSchema(), other.referenceSchema());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (tableName() != null) {
            sb.append("TableName: ").append(tableName()).append(",");
        }
        if (s3ReferenceDataSource() != null) {
            sb.append("S3ReferenceDataSource: ").append(s3ReferenceDataSource()).append(",");
        }
        if (referenceSchema() != null) {
            sb.append("ReferenceSchema: ").append(referenceSchema()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TableName":
            return Optional.of(clazz.cast(tableName()));
        case "S3ReferenceDataSource":
            return Optional.of(clazz.cast(s3ReferenceDataSource()));
        case "ReferenceSchema":
            return Optional.of(clazz.cast(referenceSchema()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ReferenceDataSourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ReferenceDataSource> {
        /**
         * <p>
         * Name of the in-application table to create.
         * </p>
         * 
         * @param tableName
         *        Name of the in-application table to create.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * Sets the value of the S3ReferenceDataSource property for this object.
         *
         * @param s3ReferenceDataSource
         *        The new value for the S3ReferenceDataSource property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3ReferenceDataSource(S3ReferenceDataSource s3ReferenceDataSource);

        /**
         * Sets the value of the S3ReferenceDataSource property for this object.
         *
         * This is a convenience that creates an instance of the {@link S3ReferenceDataSource.Builder} avoiding the need
         * to create one manually via {@link S3ReferenceDataSource#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3ReferenceDataSource.Builder#build()} is called immediately and
         * its result is passed to {@link #s3ReferenceDataSource(S3ReferenceDataSource)}.
         * 
         * @param s3ReferenceDataSource
         *        a consumer that will call methods on {@link S3ReferenceDataSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3ReferenceDataSource(S3ReferenceDataSource)
         */
        default Builder s3ReferenceDataSource(Consumer<S3ReferenceDataSource.Builder> s3ReferenceDataSource) {
            return s3ReferenceDataSource(S3ReferenceDataSource.builder().apply(s3ReferenceDataSource).build());
        }

        /**
         * Sets the value of the ReferenceSchema property for this object.
         *
         * @param referenceSchema
         *        The new value for the ReferenceSchema property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referenceSchema(SourceSchema referenceSchema);

        /**
         * Sets the value of the ReferenceSchema property for this object.
         *
         * This is a convenience that creates an instance of the {@link SourceSchema.Builder} avoiding the need to
         * create one manually via {@link SourceSchema#builder()}.
         *
         * When the {@link Consumer} completes, {@link SourceSchema.Builder#build()} is called immediately and its
         * result is passed to {@link #referenceSchema(SourceSchema)}.
         * 
         * @param referenceSchema
         *        a consumer that will call methods on {@link SourceSchema.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #referenceSchema(SourceSchema)
         */
        default Builder referenceSchema(Consumer<SourceSchema.Builder> referenceSchema) {
            return referenceSchema(SourceSchema.builder().apply(referenceSchema).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String tableName;

        private S3ReferenceDataSource s3ReferenceDataSource;

        private SourceSchema referenceSchema;

        private BuilderImpl() {
        }

        private BuilderImpl(ReferenceDataSource model) {
            tableName(model.tableName);
            s3ReferenceDataSource(model.s3ReferenceDataSource);
            referenceSchema(model.referenceSchema);
        }

        public final String getTableName() {
            return tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final S3ReferenceDataSource.Builder getS3ReferenceDataSource() {
            return s3ReferenceDataSource != null ? s3ReferenceDataSource.toBuilder() : null;
        }

        @Override
        public final Builder s3ReferenceDataSource(S3ReferenceDataSource s3ReferenceDataSource) {
            this.s3ReferenceDataSource = s3ReferenceDataSource;
            return this;
        }

        public final void setS3ReferenceDataSource(S3ReferenceDataSource.BuilderImpl s3ReferenceDataSource) {
            this.s3ReferenceDataSource = s3ReferenceDataSource != null ? s3ReferenceDataSource.build() : null;
        }

        public final SourceSchema.Builder getReferenceSchema() {
            return referenceSchema != null ? referenceSchema.toBuilder() : null;
        }

        @Override
        public final Builder referenceSchema(SourceSchema referenceSchema) {
            this.referenceSchema = referenceSchema;
            return this;
        }

        public final void setReferenceSchema(SourceSchema.BuilderImpl referenceSchema) {
            this.referenceSchema = referenceSchema != null ? referenceSchema.build() : null;
        }

        @Override
        public ReferenceDataSource build() {
            return new ReferenceDataSource(this);
        }
    }
}
