/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public class StartApplicationRequest extends KinesisAnalyticsRequest implements
        ToCopyableBuilder<StartApplicationRequest.Builder, StartApplicationRequest> {
    private final String applicationName;

    private final List<InputConfiguration> inputConfigurations;

    private StartApplicationRequest(BuilderImpl builder) {
        super(builder);
        this.applicationName = builder.applicationName;
        this.inputConfigurations = builder.inputConfigurations;
    }

    /**
     * <p>
     * Name of the application.
     * </p>
     * 
     * @return Name of the application.
     */
    public String applicationName() {
        return applicationName;
    }

    /**
     * <p>
     * Identifies the specific input, by ID, that the application starts consuming. Amazon Kinesis Analytics starts
     * reading the streaming source associated with the input. You can also specify where in the streaming source you
     * want Amazon Kinesis Analytics to start reading.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Identifies the specific input, by ID, that the application starts consuming. Amazon Kinesis Analytics
     *         starts reading the streaming source associated with the input. You can also specify where in the
     *         streaming source you want Amazon Kinesis Analytics to start reading.
     */
    public List<InputConfiguration> inputConfigurations() {
        return inputConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(inputConfigurations());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartApplicationRequest)) {
            return false;
        }
        StartApplicationRequest other = (StartApplicationRequest) obj;
        return Objects.equals(applicationName(), other.applicationName())
                && Objects.equals(inputConfigurations(), other.inputConfigurations());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (applicationName() != null) {
            sb.append("ApplicationName: ").append(applicationName()).append(",");
        }
        if (inputConfigurations() != null) {
            sb.append("InputConfigurations: ").append(inputConfigurations()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationName":
            return Optional.of(clazz.cast(applicationName()));
        case "InputConfigurations":
            return Optional.of(clazz.cast(inputConfigurations()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends KinesisAnalyticsRequest.Builder, CopyableBuilder<Builder, StartApplicationRequest> {
        /**
         * <p>
         * Name of the application.
         * </p>
         * 
         * @param applicationName
         *        Name of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationName(String applicationName);

        /**
         * <p>
         * Identifies the specific input, by ID, that the application starts consuming. Amazon Kinesis Analytics starts
         * reading the streaming source associated with the input. You can also specify where in the streaming source
         * you want Amazon Kinesis Analytics to start reading.
         * </p>
         * 
         * @param inputConfigurations
         *        Identifies the specific input, by ID, that the application starts consuming. Amazon Kinesis Analytics
         *        starts reading the streaming source associated with the input. You can also specify where in the
         *        streaming source you want Amazon Kinesis Analytics to start reading.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputConfigurations(Collection<InputConfiguration> inputConfigurations);

        /**
         * <p>
         * Identifies the specific input, by ID, that the application starts consuming. Amazon Kinesis Analytics starts
         * reading the streaming source associated with the input. You can also specify where in the streaming source
         * you want Amazon Kinesis Analytics to start reading.
         * </p>
         * 
         * @param inputConfigurations
         *        Identifies the specific input, by ID, that the application starts consuming. Amazon Kinesis Analytics
         *        starts reading the streaming source associated with the input. You can also specify where in the
         *        streaming source you want Amazon Kinesis Analytics to start reading.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputConfigurations(InputConfiguration... inputConfigurations);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends KinesisAnalyticsRequest.BuilderImpl implements Builder {
        private String applicationName;

        private List<InputConfiguration> inputConfigurations;

        private BuilderImpl() {
        }

        private BuilderImpl(StartApplicationRequest model) {
            applicationName(model.applicationName);
            inputConfigurations(model.inputConfigurations);
        }

        public final String getApplicationName() {
            return applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final Collection<InputConfiguration.Builder> getInputConfigurations() {
            return inputConfigurations != null ? inputConfigurations.stream().map(InputConfiguration::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder inputConfigurations(Collection<InputConfiguration> inputConfigurations) {
            this.inputConfigurations = InputConfigurationsCopier.copy(inputConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputConfigurations(InputConfiguration... inputConfigurations) {
            inputConfigurations(Arrays.asList(inputConfigurations));
            return this;
        }

        public final void setInputConfigurations(Collection<InputConfiguration.BuilderImpl> inputConfigurations) {
            this.inputConfigurations = InputConfigurationsCopier.copyFromBuilder(inputConfigurations);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public StartApplicationRequest build() {
            return new StartApplicationRequest(this);
        }
    }
}
