/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.services.kinesisanalytics.model.*;

import software.amazon.awssdk.core.protocol.*;
import software.amazon.awssdk.annotations.SdkInternalApi;

/**
 * ReferenceDataSourceUpdateMarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
@SdkInternalApi
public class ReferenceDataSourceUpdateMarshaller {

    private static final MarshallingInfo<String> REFERENCEID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReferenceId").build();
    private static final MarshallingInfo<String> TABLENAMEUPDATE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TableNameUpdate").build();
    private static final MarshallingInfo<StructuredPojo> S3REFERENCEDATASOURCEUPDATE_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("S3ReferenceDataSourceUpdate").build();
    private static final MarshallingInfo<StructuredPojo> REFERENCESCHEMAUPDATE_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("ReferenceSchemaUpdate").build();

    private static final ReferenceDataSourceUpdateMarshaller INSTANCE = new ReferenceDataSourceUpdateMarshaller();

    public static ReferenceDataSourceUpdateMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(ReferenceDataSourceUpdate referenceDataSourceUpdate, ProtocolMarshaller protocolMarshaller) {

        if (referenceDataSourceUpdate == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {

            protocolMarshaller.marshall(referenceDataSourceUpdate.referenceId(), REFERENCEID_BINDING);

            protocolMarshaller.marshall(referenceDataSourceUpdate.tableNameUpdate(), TABLENAMEUPDATE_BINDING);

            protocolMarshaller.marshall(referenceDataSourceUpdate.s3ReferenceDataSourceUpdate(),
                    S3REFERENCEDATASOURCEUPDATE_BINDING);

            protocolMarshaller.marshall(referenceDataSourceUpdate.referenceSchemaUpdate(), REFERENCESCHEMAUPDATE_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
