/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.firehose.transform.ProcessorParameterMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the processor parameter.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ProcessorParameter implements StructuredPojo, ToCopyableBuilder<ProcessorParameter.Builder, ProcessorParameter> {
    private final String parameterName;

    private final String parameterValue;

    private ProcessorParameter(BuilderImpl builder) {
        this.parameterName = builder.parameterName;
        this.parameterValue = builder.parameterValue;
    }

    /**
     * <p>
     * The name of the parameter.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #parameterName}
     * will return {@link ProcessorParameterName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #parameterNameString}.
     * </p>
     * 
     * @return The name of the parameter.
     * @see ProcessorParameterName
     */
    public ProcessorParameterName parameterName() {
        return ProcessorParameterName.fromValue(parameterName);
    }

    /**
     * <p>
     * The name of the parameter.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #parameterName}
     * will return {@link ProcessorParameterName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #parameterNameString}.
     * </p>
     * 
     * @return The name of the parameter.
     * @see ProcessorParameterName
     */
    public String parameterNameString() {
        return parameterName;
    }

    /**
     * <p>
     * The parameter value.
     * </p>
     * 
     * @return The parameter value.
     */
    public String parameterValue() {
        return parameterValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(parameterNameString());
        hashCode = 31 * hashCode + Objects.hashCode(parameterValue());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProcessorParameter)) {
            return false;
        }
        ProcessorParameter other = (ProcessorParameter) obj;
        return Objects.equals(parameterNameString(), other.parameterNameString())
                && Objects.equals(parameterValue(), other.parameterValue());
    }

    @Override
    public String toString() {
        return ToString.builder("ProcessorParameter").add("ParameterName", parameterNameString())
                .add("ParameterValue", parameterValue()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ParameterName":
            return Optional.of(clazz.cast(parameterNameString()));
        case "ParameterValue":
            return Optional.of(clazz.cast(parameterValue()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ProcessorParameterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ProcessorParameter> {
        /**
         * <p>
         * The name of the parameter.
         * </p>
         * 
         * @param parameterName
         *        The name of the parameter.
         * @see ProcessorParameterName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProcessorParameterName
         */
        Builder parameterName(String parameterName);

        /**
         * <p>
         * The name of the parameter.
         * </p>
         * 
         * @param parameterName
         *        The name of the parameter.
         * @see ProcessorParameterName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProcessorParameterName
         */
        Builder parameterName(ProcessorParameterName parameterName);

        /**
         * <p>
         * The parameter value.
         * </p>
         * 
         * @param parameterValue
         *        The parameter value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterValue(String parameterValue);
    }

    static final class BuilderImpl implements Builder {
        private String parameterName;

        private String parameterValue;

        private BuilderImpl() {
        }

        private BuilderImpl(ProcessorParameter model) {
            parameterName(model.parameterName);
            parameterValue(model.parameterValue);
        }

        public final String getParameterName() {
            return parameterName;
        }

        @Override
        public final Builder parameterName(String parameterName) {
            this.parameterName = parameterName;
            return this;
        }

        @Override
        public final Builder parameterName(ProcessorParameterName parameterName) {
            this.parameterName(parameterName.toString());
            return this;
        }

        public final void setParameterName(String parameterName) {
            this.parameterName = parameterName;
        }

        public final String getParameterValue() {
            return parameterValue;
        }

        @Override
        public final Builder parameterValue(String parameterValue) {
            this.parameterValue = parameterValue;
            return this;
        }

        public final void setParameterValue(String parameterValue) {
            this.parameterValue = parameterValue;
        }

        @Override
        public ProcessorParameter build() {
            return new ProcessorParameter(this);
        }
    }
}
