/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.firehose.transform.RedshiftDestinationDescriptionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a destination in Amazon Redshift.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class RedshiftDestinationDescription implements StructuredPojo,
        ToCopyableBuilder<RedshiftDestinationDescription.Builder, RedshiftDestinationDescription> {
    private final String roleARN;

    private final String clusterJDBCURL;

    private final CopyCommand copyCommand;

    private final String username;

    private final RedshiftRetryOptions retryOptions;

    private final S3DestinationDescription s3DestinationDescription;

    private final ProcessingConfiguration processingConfiguration;

    private final String s3BackupMode;

    private final S3DestinationDescription s3BackupDescription;

    private final CloudWatchLoggingOptions cloudWatchLoggingOptions;

    private RedshiftDestinationDescription(BuilderImpl builder) {
        this.roleARN = builder.roleARN;
        this.clusterJDBCURL = builder.clusterJDBCURL;
        this.copyCommand = builder.copyCommand;
        this.username = builder.username;
        this.retryOptions = builder.retryOptions;
        this.s3DestinationDescription = builder.s3DestinationDescription;
        this.processingConfiguration = builder.processingConfiguration;
        this.s3BackupMode = builder.s3BackupMode;
        this.s3BackupDescription = builder.s3BackupDescription;
        this.cloudWatchLoggingOptions = builder.cloudWatchLoggingOptions;
    }

    /**
     * <p>
     * The ARN of the AWS credentials.
     * </p>
     * 
     * @return The ARN of the AWS credentials.
     */
    public String roleARN() {
        return roleARN;
    }

    /**
     * <p>
     * The database connection string.
     * </p>
     * 
     * @return The database connection string.
     */
    public String clusterJDBCURL() {
        return clusterJDBCURL;
    }

    /**
     * <p>
     * The <code>COPY</code> command.
     * </p>
     * 
     * @return The <code>COPY</code> command.
     */
    public CopyCommand copyCommand() {
        return copyCommand;
    }

    /**
     * <p>
     * The name of the user.
     * </p>
     * 
     * @return The name of the user.
     */
    public String username() {
        return username;
    }

    /**
     * <p>
     * The retry behavior in case Kinesis Firehose is unable to deliver documents to Amazon Redshift. Default value is
     * 3600 (60 minutes).
     * </p>
     * 
     * @return The retry behavior in case Kinesis Firehose is unable to deliver documents to Amazon Redshift. Default
     *         value is 3600 (60 minutes).
     */
    public RedshiftRetryOptions retryOptions() {
        return retryOptions;
    }

    /**
     * <p>
     * The Amazon S3 destination.
     * </p>
     * 
     * @return The Amazon S3 destination.
     */
    public S3DestinationDescription s3DestinationDescription() {
        return s3DestinationDescription;
    }

    /**
     * <p>
     * The data processing configuration.
     * </p>
     * 
     * @return The data processing configuration.
     */
    public ProcessingConfiguration processingConfiguration() {
        return processingConfiguration;
    }

    /**
     * <p>
     * The Amazon S3 backup mode.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #s3BackupMode} will
     * return {@link RedshiftS3BackupMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #s3BackupModeString}.
     * </p>
     * 
     * @return The Amazon S3 backup mode.
     * @see RedshiftS3BackupMode
     */
    public RedshiftS3BackupMode s3BackupMode() {
        return RedshiftS3BackupMode.fromValue(s3BackupMode);
    }

    /**
     * <p>
     * The Amazon S3 backup mode.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #s3BackupMode} will
     * return {@link RedshiftS3BackupMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #s3BackupModeString}.
     * </p>
     * 
     * @return The Amazon S3 backup mode.
     * @see RedshiftS3BackupMode
     */
    public String s3BackupModeString() {
        return s3BackupMode;
    }

    /**
     * <p>
     * The configuration for backup in Amazon S3.
     * </p>
     * 
     * @return The configuration for backup in Amazon S3.
     */
    public S3DestinationDescription s3BackupDescription() {
        return s3BackupDescription;
    }

    /**
     * <p>
     * The CloudWatch logging options for your delivery stream.
     * </p>
     * 
     * @return The CloudWatch logging options for your delivery stream.
     */
    public CloudWatchLoggingOptions cloudWatchLoggingOptions() {
        return cloudWatchLoggingOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(clusterJDBCURL());
        hashCode = 31 * hashCode + Objects.hashCode(copyCommand());
        hashCode = 31 * hashCode + Objects.hashCode(username());
        hashCode = 31 * hashCode + Objects.hashCode(retryOptions());
        hashCode = 31 * hashCode + Objects.hashCode(s3DestinationDescription());
        hashCode = 31 * hashCode + Objects.hashCode(processingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(s3BackupModeString());
        hashCode = 31 * hashCode + Objects.hashCode(s3BackupDescription());
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchLoggingOptions());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedshiftDestinationDescription)) {
            return false;
        }
        RedshiftDestinationDescription other = (RedshiftDestinationDescription) obj;
        return Objects.equals(roleARN(), other.roleARN()) && Objects.equals(clusterJDBCURL(), other.clusterJDBCURL())
                && Objects.equals(copyCommand(), other.copyCommand()) && Objects.equals(username(), other.username())
                && Objects.equals(retryOptions(), other.retryOptions())
                && Objects.equals(s3DestinationDescription(), other.s3DestinationDescription())
                && Objects.equals(processingConfiguration(), other.processingConfiguration())
                && Objects.equals(s3BackupModeString(), other.s3BackupModeString())
                && Objects.equals(s3BackupDescription(), other.s3BackupDescription())
                && Objects.equals(cloudWatchLoggingOptions(), other.cloudWatchLoggingOptions());
    }

    @Override
    public String toString() {
        return ToString.builder("RedshiftDestinationDescription").add("RoleARN", roleARN())
                .add("ClusterJDBCURL", clusterJDBCURL()).add("CopyCommand", copyCommand()).add("Username", username())
                .add("RetryOptions", retryOptions()).add("S3DestinationDescription", s3DestinationDescription())
                .add("ProcessingConfiguration", processingConfiguration()).add("S3BackupMode", s3BackupModeString())
                .add("S3BackupDescription", s3BackupDescription()).add("CloudWatchLoggingOptions", cloudWatchLoggingOptions())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RoleARN":
            return Optional.of(clazz.cast(roleARN()));
        case "ClusterJDBCURL":
            return Optional.of(clazz.cast(clusterJDBCURL()));
        case "CopyCommand":
            return Optional.of(clazz.cast(copyCommand()));
        case "Username":
            return Optional.of(clazz.cast(username()));
        case "RetryOptions":
            return Optional.of(clazz.cast(retryOptions()));
        case "S3DestinationDescription":
            return Optional.of(clazz.cast(s3DestinationDescription()));
        case "ProcessingConfiguration":
            return Optional.of(clazz.cast(processingConfiguration()));
        case "S3BackupMode":
            return Optional.of(clazz.cast(s3BackupModeString()));
        case "S3BackupDescription":
            return Optional.of(clazz.cast(s3BackupDescription()));
        case "CloudWatchLoggingOptions":
            return Optional.of(clazz.cast(cloudWatchLoggingOptions()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RedshiftDestinationDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, RedshiftDestinationDescription> {
        /**
         * <p>
         * The ARN of the AWS credentials.
         * </p>
         * 
         * @param roleARN
         *        The ARN of the AWS credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleARN(String roleARN);

        /**
         * <p>
         * The database connection string.
         * </p>
         * 
         * @param clusterJDBCURL
         *        The database connection string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterJDBCURL(String clusterJDBCURL);

        /**
         * <p>
         * The <code>COPY</code> command.
         * </p>
         * 
         * @param copyCommand
         *        The <code>COPY</code> command.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copyCommand(CopyCommand copyCommand);

        /**
         * <p>
         * The <code>COPY</code> command.
         * </p>
         * This is a convenience that creates an instance of the {@link CopyCommand.Builder} avoiding the need to create
         * one manually via {@link CopyCommand#builder()}.
         *
         * When the {@link Consumer} completes, {@link CopyCommand.Builder#build()} is called immediately and its result
         * is passed to {@link #copyCommand(CopyCommand)}.
         * 
         * @param copyCommand
         *        a consumer that will call methods on {@link CopyCommand.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #copyCommand(CopyCommand)
         */
        default Builder copyCommand(Consumer<CopyCommand.Builder> copyCommand) {
            return copyCommand(CopyCommand.builder().apply(copyCommand).build());
        }

        /**
         * <p>
         * The name of the user.
         * </p>
         * 
         * @param username
         *        The name of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder username(String username);

        /**
         * <p>
         * The retry behavior in case Kinesis Firehose is unable to deliver documents to Amazon Redshift. Default value
         * is 3600 (60 minutes).
         * </p>
         * 
         * @param retryOptions
         *        The retry behavior in case Kinesis Firehose is unable to deliver documents to Amazon Redshift. Default
         *        value is 3600 (60 minutes).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retryOptions(RedshiftRetryOptions retryOptions);

        /**
         * <p>
         * The retry behavior in case Kinesis Firehose is unable to deliver documents to Amazon Redshift. Default value
         * is 3600 (60 minutes).
         * </p>
         * This is a convenience that creates an instance of the {@link RedshiftRetryOptions.Builder} avoiding the need
         * to create one manually via {@link RedshiftRetryOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link RedshiftRetryOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #retryOptions(RedshiftRetryOptions)}.
         * 
         * @param retryOptions
         *        a consumer that will call methods on {@link RedshiftRetryOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #retryOptions(RedshiftRetryOptions)
         */
        default Builder retryOptions(Consumer<RedshiftRetryOptions.Builder> retryOptions) {
            return retryOptions(RedshiftRetryOptions.builder().apply(retryOptions).build());
        }

        /**
         * <p>
         * The Amazon S3 destination.
         * </p>
         * 
         * @param s3DestinationDescription
         *        The Amazon S3 destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3DestinationDescription(S3DestinationDescription s3DestinationDescription);

        /**
         * <p>
         * The Amazon S3 destination.
         * </p>
         * This is a convenience that creates an instance of the {@link S3DestinationDescription.Builder} avoiding the
         * need to create one manually via {@link S3DestinationDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3DestinationDescription.Builder#build()} is called immediately
         * and its result is passed to {@link #s3DestinationDescription(S3DestinationDescription)}.
         * 
         * @param s3DestinationDescription
         *        a consumer that will call methods on {@link S3DestinationDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3DestinationDescription(S3DestinationDescription)
         */
        default Builder s3DestinationDescription(Consumer<S3DestinationDescription.Builder> s3DestinationDescription) {
            return s3DestinationDescription(S3DestinationDescription.builder().apply(s3DestinationDescription).build());
        }

        /**
         * <p>
         * The data processing configuration.
         * </p>
         * 
         * @param processingConfiguration
         *        The data processing configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processingConfiguration(ProcessingConfiguration processingConfiguration);

        /**
         * <p>
         * The data processing configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link ProcessingConfiguration.Builder} avoiding the
         * need to create one manually via {@link ProcessingConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProcessingConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #processingConfiguration(ProcessingConfiguration)}.
         * 
         * @param processingConfiguration
         *        a consumer that will call methods on {@link ProcessingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #processingConfiguration(ProcessingConfiguration)
         */
        default Builder processingConfiguration(Consumer<ProcessingConfiguration.Builder> processingConfiguration) {
            return processingConfiguration(ProcessingConfiguration.builder().apply(processingConfiguration).build());
        }

        /**
         * <p>
         * The Amazon S3 backup mode.
         * </p>
         * 
         * @param s3BackupMode
         *        The Amazon S3 backup mode.
         * @see RedshiftS3BackupMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RedshiftS3BackupMode
         */
        Builder s3BackupMode(String s3BackupMode);

        /**
         * <p>
         * The Amazon S3 backup mode.
         * </p>
         * 
         * @param s3BackupMode
         *        The Amazon S3 backup mode.
         * @see RedshiftS3BackupMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RedshiftS3BackupMode
         */
        Builder s3BackupMode(RedshiftS3BackupMode s3BackupMode);

        /**
         * <p>
         * The configuration for backup in Amazon S3.
         * </p>
         * 
         * @param s3BackupDescription
         *        The configuration for backup in Amazon S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3BackupDescription(S3DestinationDescription s3BackupDescription);

        /**
         * <p>
         * The configuration for backup in Amazon S3.
         * </p>
         * This is a convenience that creates an instance of the {@link S3DestinationDescription.Builder} avoiding the
         * need to create one manually via {@link S3DestinationDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3DestinationDescription.Builder#build()} is called immediately
         * and its result is passed to {@link #s3BackupDescription(S3DestinationDescription)}.
         * 
         * @param s3BackupDescription
         *        a consumer that will call methods on {@link S3DestinationDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3BackupDescription(S3DestinationDescription)
         */
        default Builder s3BackupDescription(Consumer<S3DestinationDescription.Builder> s3BackupDescription) {
            return s3BackupDescription(S3DestinationDescription.builder().apply(s3BackupDescription).build());
        }

        /**
         * <p>
         * The CloudWatch logging options for your delivery stream.
         * </p>
         * 
         * @param cloudWatchLoggingOptions
         *        The CloudWatch logging options for your delivery stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLoggingOptions(CloudWatchLoggingOptions cloudWatchLoggingOptions);

        /**
         * <p>
         * The CloudWatch logging options for your delivery stream.
         * </p>
         * This is a convenience that creates an instance of the {@link CloudWatchLoggingOptions.Builder} avoiding the
         * need to create one manually via {@link CloudWatchLoggingOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link CloudWatchLoggingOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #cloudWatchLoggingOptions(CloudWatchLoggingOptions)}.
         * 
         * @param cloudWatchLoggingOptions
         *        a consumer that will call methods on {@link CloudWatchLoggingOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudWatchLoggingOptions(CloudWatchLoggingOptions)
         */
        default Builder cloudWatchLoggingOptions(Consumer<CloudWatchLoggingOptions.Builder> cloudWatchLoggingOptions) {
            return cloudWatchLoggingOptions(CloudWatchLoggingOptions.builder().apply(cloudWatchLoggingOptions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String roleARN;

        private String clusterJDBCURL;

        private CopyCommand copyCommand;

        private String username;

        private RedshiftRetryOptions retryOptions;

        private S3DestinationDescription s3DestinationDescription;

        private ProcessingConfiguration processingConfiguration;

        private String s3BackupMode;

        private S3DestinationDescription s3BackupDescription;

        private CloudWatchLoggingOptions cloudWatchLoggingOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(RedshiftDestinationDescription model) {
            roleARN(model.roleARN);
            clusterJDBCURL(model.clusterJDBCURL);
            copyCommand(model.copyCommand);
            username(model.username);
            retryOptions(model.retryOptions);
            s3DestinationDescription(model.s3DestinationDescription);
            processingConfiguration(model.processingConfiguration);
            s3BackupMode(model.s3BackupMode);
            s3BackupDescription(model.s3BackupDescription);
            cloudWatchLoggingOptions(model.cloudWatchLoggingOptions);
        }

        public final String getRoleARN() {
            return roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public final String getClusterJDBCURL() {
            return clusterJDBCURL;
        }

        @Override
        public final Builder clusterJDBCURL(String clusterJDBCURL) {
            this.clusterJDBCURL = clusterJDBCURL;
            return this;
        }

        public final void setClusterJDBCURL(String clusterJDBCURL) {
            this.clusterJDBCURL = clusterJDBCURL;
        }

        public final CopyCommand.Builder getCopyCommand() {
            return copyCommand != null ? copyCommand.toBuilder() : null;
        }

        @Override
        public final Builder copyCommand(CopyCommand copyCommand) {
            this.copyCommand = copyCommand;
            return this;
        }

        public final void setCopyCommand(CopyCommand.BuilderImpl copyCommand) {
            this.copyCommand = copyCommand != null ? copyCommand.build() : null;
        }

        public final String getUsername() {
            return username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        public final RedshiftRetryOptions.Builder getRetryOptions() {
            return retryOptions != null ? retryOptions.toBuilder() : null;
        }

        @Override
        public final Builder retryOptions(RedshiftRetryOptions retryOptions) {
            this.retryOptions = retryOptions;
            return this;
        }

        public final void setRetryOptions(RedshiftRetryOptions.BuilderImpl retryOptions) {
            this.retryOptions = retryOptions != null ? retryOptions.build() : null;
        }

        public final S3DestinationDescription.Builder getS3DestinationDescription() {
            return s3DestinationDescription != null ? s3DestinationDescription.toBuilder() : null;
        }

        @Override
        public final Builder s3DestinationDescription(S3DestinationDescription s3DestinationDescription) {
            this.s3DestinationDescription = s3DestinationDescription;
            return this;
        }

        public final void setS3DestinationDescription(S3DestinationDescription.BuilderImpl s3DestinationDescription) {
            this.s3DestinationDescription = s3DestinationDescription != null ? s3DestinationDescription.build() : null;
        }

        public final ProcessingConfiguration.Builder getProcessingConfiguration() {
            return processingConfiguration != null ? processingConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder processingConfiguration(ProcessingConfiguration processingConfiguration) {
            this.processingConfiguration = processingConfiguration;
            return this;
        }

        public final void setProcessingConfiguration(ProcessingConfiguration.BuilderImpl processingConfiguration) {
            this.processingConfiguration = processingConfiguration != null ? processingConfiguration.build() : null;
        }

        public final String getS3BackupMode() {
            return s3BackupMode;
        }

        @Override
        public final Builder s3BackupMode(String s3BackupMode) {
            this.s3BackupMode = s3BackupMode;
            return this;
        }

        @Override
        public final Builder s3BackupMode(RedshiftS3BackupMode s3BackupMode) {
            this.s3BackupMode(s3BackupMode.toString());
            return this;
        }

        public final void setS3BackupMode(String s3BackupMode) {
            this.s3BackupMode = s3BackupMode;
        }

        public final S3DestinationDescription.Builder getS3BackupDescription() {
            return s3BackupDescription != null ? s3BackupDescription.toBuilder() : null;
        }

        @Override
        public final Builder s3BackupDescription(S3DestinationDescription s3BackupDescription) {
            this.s3BackupDescription = s3BackupDescription;
            return this;
        }

        public final void setS3BackupDescription(S3DestinationDescription.BuilderImpl s3BackupDescription) {
            this.s3BackupDescription = s3BackupDescription != null ? s3BackupDescription.build() : null;
        }

        public final CloudWatchLoggingOptions.Builder getCloudWatchLoggingOptions() {
            return cloudWatchLoggingOptions != null ? cloudWatchLoggingOptions.toBuilder() : null;
        }

        @Override
        public final Builder cloudWatchLoggingOptions(CloudWatchLoggingOptions cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
            return this;
        }

        public final void setCloudWatchLoggingOptions(CloudWatchLoggingOptions.BuilderImpl cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = cloudWatchLoggingOptions != null ? cloudWatchLoggingOptions.build() : null;
        }

        @Override
        public RedshiftDestinationDescription build() {
            return new RedshiftDestinationDescription(this);
        }
    }
}
