/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.services.firehose.model.*;

import software.amazon.awssdk.core.protocol.*;
import software.amazon.awssdk.annotations.SdkInternalApi;

/**
 * CreateDeliveryStreamRequestMarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
@SdkInternalApi
public class CreateDeliveryStreamRequestModelMarshaller {

    private static final MarshallingInfo<String> DELIVERYSTREAMNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeliveryStreamName").build();
    private static final MarshallingInfo<String> DELIVERYSTREAMTYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeliveryStreamType").build();
    private static final MarshallingInfo<StructuredPojo> KINESISSTREAMSOURCECONFIGURATION_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("KinesisStreamSourceConfiguration").build();
    private static final MarshallingInfo<StructuredPojo> S3DESTINATIONCONFIGURATION_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("S3DestinationConfiguration").build();
    private static final MarshallingInfo<StructuredPojo> EXTENDEDS3DESTINATIONCONFIGURATION_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("ExtendedS3DestinationConfiguration").build();
    private static final MarshallingInfo<StructuredPojo> REDSHIFTDESTINATIONCONFIGURATION_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("RedshiftDestinationConfiguration").build();
    private static final MarshallingInfo<StructuredPojo> ELASTICSEARCHDESTINATIONCONFIGURATION_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("ElasticsearchDestinationConfiguration").build();
    private static final MarshallingInfo<StructuredPojo> SPLUNKDESTINATIONCONFIGURATION_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("SplunkDestinationConfiguration").build();

    private static final CreateDeliveryStreamRequestModelMarshaller INSTANCE = new CreateDeliveryStreamRequestModelMarshaller();

    public static CreateDeliveryStreamRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(CreateDeliveryStreamRequest createDeliveryStreamRequest, ProtocolMarshaller protocolMarshaller) {

        if (createDeliveryStreamRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {

            protocolMarshaller.marshall(createDeliveryStreamRequest.deliveryStreamName(), DELIVERYSTREAMNAME_BINDING);

            protocolMarshaller.marshall(createDeliveryStreamRequest.deliveryStreamTypeString(), DELIVERYSTREAMTYPE_BINDING);

            protocolMarshaller.marshall(createDeliveryStreamRequest.kinesisStreamSourceConfiguration(),
                    KINESISSTREAMSOURCECONFIGURATION_BINDING);

            protocolMarshaller.marshall(createDeliveryStreamRequest.s3DestinationConfiguration(),
                    S3DESTINATIONCONFIGURATION_BINDING);

            protocolMarshaller.marshall(createDeliveryStreamRequest.extendedS3DestinationConfiguration(),
                    EXTENDEDS3DESTINATIONCONFIGURATION_BINDING);

            protocolMarshaller.marshall(createDeliveryStreamRequest.redshiftDestinationConfiguration(),
                    REDSHIFTDESTINATIONCONFIGURATION_BINDING);

            protocolMarshaller.marshall(createDeliveryStreamRequest.elasticsearchDestinationConfiguration(),
                    ELASTICSEARCHDESTINATIONCONFIGURATION_BINDING);

            protocolMarshaller.marshall(createDeliveryStreamRequest.splunkDestinationConfiguration(),
                    SPLUNKDESTINATIONCONFIGURATION_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
