/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.transform;

import java.util.List;
import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.services.firehose.model.*;

import software.amazon.awssdk.core.protocol.*;
import software.amazon.awssdk.annotations.SdkInternalApi;

/**
 * DeliveryStreamDescriptionMarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
@SdkInternalApi
public class DeliveryStreamDescriptionMarshaller {

    private static final MarshallingInfo<String> DELIVERYSTREAMNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeliveryStreamName").build();
    private static final MarshallingInfo<String> DELIVERYSTREAMARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeliveryStreamARN").build();
    private static final MarshallingInfo<String> DELIVERYSTREAMSTATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeliveryStreamStatus").build();
    private static final MarshallingInfo<String> DELIVERYSTREAMTYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeliveryStreamType").build();
    private static final MarshallingInfo<String> VERSIONID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VersionId").build();
    private static final MarshallingInfo<java.time.Instant> CREATETIMESTAMP_BINDING = MarshallingInfo
            .builder(MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreateTimestamp")
            .build();
    private static final MarshallingInfo<java.time.Instant> LASTUPDATETIMESTAMP_BINDING = MarshallingInfo
            .builder(MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("LastUpdateTimestamp").build();
    private static final MarshallingInfo<StructuredPojo> SOURCE_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Source").build();
    private static final MarshallingInfo<List> DESTINATIONS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Destinations").build();
    private static final MarshallingInfo<Boolean> HASMOREDESTINATIONS_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HasMoreDestinations").build();

    private static final DeliveryStreamDescriptionMarshaller INSTANCE = new DeliveryStreamDescriptionMarshaller();

    public static DeliveryStreamDescriptionMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(DeliveryStreamDescription deliveryStreamDescription, ProtocolMarshaller protocolMarshaller) {

        if (deliveryStreamDescription == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {

            protocolMarshaller.marshall(deliveryStreamDescription.deliveryStreamName(), DELIVERYSTREAMNAME_BINDING);

            protocolMarshaller.marshall(deliveryStreamDescription.deliveryStreamARN(), DELIVERYSTREAMARN_BINDING);

            protocolMarshaller.marshall(deliveryStreamDescription.deliveryStreamStatusString(), DELIVERYSTREAMSTATUS_BINDING);

            protocolMarshaller.marshall(deliveryStreamDescription.deliveryStreamTypeString(), DELIVERYSTREAMTYPE_BINDING);

            protocolMarshaller.marshall(deliveryStreamDescription.versionId(), VERSIONID_BINDING);

            protocolMarshaller.marshall(deliveryStreamDescription.createTimestamp(), CREATETIMESTAMP_BINDING);

            protocolMarshaller.marshall(deliveryStreamDescription.lastUpdateTimestamp(), LASTUPDATETIMESTAMP_BINDING);

            protocolMarshaller.marshall(deliveryStreamDescription.source(), SOURCE_BINDING);

            protocolMarshaller.marshall(deliveryStreamDescription.destinations(), DESTINATIONS_BINDING);

            protocolMarshaller.marshall(deliveryStreamDescription.hasMoreDestinations(), HASMOREDESTINATIONS_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
