/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeApplicationResponse extends KinesisAnalyticsResponse implements
        ToCopyableBuilder<DescribeApplicationResponse.Builder, DescribeApplicationResponse> {
    private final ApplicationDetail applicationDetail;

    private DescribeApplicationResponse(BuilderImpl builder) {
        super(builder);
        this.applicationDetail = builder.applicationDetail;
    }

    /**
     * <p>
     * Provides a description of the application, such as the application Amazon Resource Name (ARN), status, latest
     * version, and input and output configuration details.
     * </p>
     * 
     * @return Provides a description of the application, such as the application Amazon Resource Name (ARN), status,
     *         latest version, and input and output configuration details.
     */
    public ApplicationDetail applicationDetail() {
        return applicationDetail;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationDetail());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeApplicationResponse)) {
            return false;
        }
        DescribeApplicationResponse other = (DescribeApplicationResponse) obj;
        return Objects.equals(applicationDetail(), other.applicationDetail());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeApplicationResponse").add("ApplicationDetail", applicationDetail()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationDetail":
            return Optional.of(clazz.cast(applicationDetail()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends KinesisAnalyticsResponse.Builder, CopyableBuilder<Builder, DescribeApplicationResponse> {
        /**
         * <p>
         * Provides a description of the application, such as the application Amazon Resource Name (ARN), status, latest
         * version, and input and output configuration details.
         * </p>
         * 
         * @param applicationDetail
         *        Provides a description of the application, such as the application Amazon Resource Name (ARN), status,
         *        latest version, and input and output configuration details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationDetail(ApplicationDetail applicationDetail);

        /**
         * <p>
         * Provides a description of the application, such as the application Amazon Resource Name (ARN), status, latest
         * version, and input and output configuration details.
         * </p>
         * This is a convenience that creates an instance of the {@link ApplicationDetail.Builder} avoiding the need to
         * create one manually via {@link ApplicationDetail#builder()}.
         *
         * When the {@link Consumer} completes, {@link ApplicationDetail.Builder#build()} is called immediately and its
         * result is passed to {@link #applicationDetail(ApplicationDetail)}.
         * 
         * @param applicationDetail
         *        a consumer that will call methods on {@link ApplicationDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #applicationDetail(ApplicationDetail)
         */
        default Builder applicationDetail(Consumer<ApplicationDetail.Builder> applicationDetail) {
            return applicationDetail(ApplicationDetail.builder().apply(applicationDetail).build());
        }
    }

    static final class BuilderImpl extends KinesisAnalyticsResponse.BuilderImpl implements Builder {
        private ApplicationDetail applicationDetail;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeApplicationResponse model) {
            applicationDetail(model.applicationDetail);
        }

        public final ApplicationDetail.Builder getApplicationDetail() {
            return applicationDetail != null ? applicationDetail.toBuilder() : null;
        }

        @Override
        public final Builder applicationDetail(ApplicationDetail applicationDetail) {
            this.applicationDetail = applicationDetail;
            return this;
        }

        public final void setApplicationDetail(ApplicationDetail.BuilderImpl applicationDetail) {
            this.applicationDetail = applicationDetail != null ? applicationDetail.build() : null;
        }

        @Override
        public DescribeApplicationResponse build() {
            return new DescribeApplicationResponse(this);
        }
    }
}
