/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.transform.InputLambdaProcessorDescriptionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains the ARN of the <a href="https://aws.amazon.com/documentation/lambda/">AWS Lambda</a> function
 * that is used to preprocess records in the stream, and the ARN of the IAM role used to access the AWS Lambda
 * expression.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class InputLambdaProcessorDescription implements StructuredPojo,
        ToCopyableBuilder<InputLambdaProcessorDescription.Builder, InputLambdaProcessorDescription> {
    private final String resourceARN;

    private final String roleARN;

    private InputLambdaProcessorDescription(BuilderImpl builder) {
        this.resourceARN = builder.resourceARN;
        this.roleARN = builder.roleARN;
    }

    /**
     * <p>
     * The ARN of the <a href="https://aws.amazon.com/documentation/lambda/">AWS Lambda</a> function that is used to
     * preprocess the records in the stream.
     * </p>
     * 
     * @return The ARN of the <a href="https://aws.amazon.com/documentation/lambda/">AWS Lambda</a> function that is
     *         used to preprocess the records in the stream.
     */
    public String resourceARN() {
        return resourceARN;
    }

    /**
     * <p>
     * The ARN of the IAM role used to access the AWS Lambda function.
     * </p>
     * 
     * @return The ARN of the IAM role used to access the AWS Lambda function.
     */
    public String roleARN() {
        return roleARN;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceARN());
        hashCode = 31 * hashCode + Objects.hashCode(roleARN());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputLambdaProcessorDescription)) {
            return false;
        }
        InputLambdaProcessorDescription other = (InputLambdaProcessorDescription) obj;
        return Objects.equals(resourceARN(), other.resourceARN()) && Objects.equals(roleARN(), other.roleARN());
    }

    @Override
    public String toString() {
        return ToString.builder("InputLambdaProcessorDescription").add("ResourceARN", resourceARN()).add("RoleARN", roleARN())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceARN":
            return Optional.of(clazz.cast(resourceARN()));
        case "RoleARN":
            return Optional.of(clazz.cast(roleARN()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InputLambdaProcessorDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, InputLambdaProcessorDescription> {
        /**
         * <p>
         * The ARN of the <a href="https://aws.amazon.com/documentation/lambda/">AWS Lambda</a> function that is used to
         * preprocess the records in the stream.
         * </p>
         * 
         * @param resourceARN
         *        The ARN of the <a href="https://aws.amazon.com/documentation/lambda/">AWS Lambda</a> function that is
         *        used to preprocess the records in the stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceARN(String resourceARN);

        /**
         * <p>
         * The ARN of the IAM role used to access the AWS Lambda function.
         * </p>
         * 
         * @param roleARN
         *        The ARN of the IAM role used to access the AWS Lambda function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleARN(String roleARN);
    }

    static final class BuilderImpl implements Builder {
        private String resourceARN;

        private String roleARN;

        private BuilderImpl() {
        }

        private BuilderImpl(InputLambdaProcessorDescription model) {
            resourceARN(model.resourceARN);
            roleARN(model.roleARN);
        }

        public final String getResourceARN() {
            return resourceARN;
        }

        @Override
        public final Builder resourceARN(String resourceARN) {
            this.resourceARN = resourceARN;
            return this;
        }

        public final void setResourceARN(String resourceARN) {
            this.resourceARN = resourceARN;
        }

        public final String getRoleARN() {
            return roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        @Override
        public InputLambdaProcessorDescription build() {
            return new InputLambdaProcessorDescription(this);
        }
    }
}
