/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.transform.InputParallelismUpdateMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides updates to the parallelism count.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class InputParallelismUpdate implements StructuredPojo,
        ToCopyableBuilder<InputParallelismUpdate.Builder, InputParallelismUpdate> {
    private final Integer countUpdate;

    private InputParallelismUpdate(BuilderImpl builder) {
        this.countUpdate = builder.countUpdate;
    }

    /**
     * <p>
     * Number of in-application streams to create for the specified streaming source.
     * </p>
     * 
     * @return Number of in-application streams to create for the specified streaming source.
     */
    public Integer countUpdate() {
        return countUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(countUpdate());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputParallelismUpdate)) {
            return false;
        }
        InputParallelismUpdate other = (InputParallelismUpdate) obj;
        return Objects.equals(countUpdate(), other.countUpdate());
    }

    @Override
    public String toString() {
        return ToString.builder("InputParallelismUpdate").add("CountUpdate", countUpdate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CountUpdate":
            return Optional.of(clazz.cast(countUpdate()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InputParallelismUpdateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, InputParallelismUpdate> {
        /**
         * <p>
         * Number of in-application streams to create for the specified streaming source.
         * </p>
         * 
         * @param countUpdate
         *        Number of in-application streams to create for the specified streaming source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder countUpdate(Integer countUpdate);
    }

    static final class BuilderImpl implements Builder {
        private Integer countUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(InputParallelismUpdate model) {
            countUpdate(model.countUpdate);
        }

        public final Integer getCountUpdate() {
            return countUpdate;
        }

        @Override
        public final Builder countUpdate(Integer countUpdate) {
            this.countUpdate = countUpdate;
            return this;
        }

        public final void setCountUpdate(Integer countUpdate) {
            this.countUpdate = countUpdate;
        }

        @Override
        public InputParallelismUpdate build() {
            return new InputParallelismUpdate(this);
        }
    }
}
