/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.transform.MappingParametersMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * When configuring application input at the time of creating or updating an application, provides additional mapping
 * information specific to the record format (such as JSON, CSV, or record fields delimited by some delimiter) on the
 * streaming source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class MappingParameters implements StructuredPojo, ToCopyableBuilder<MappingParameters.Builder, MappingParameters> {
    private final JSONMappingParameters jsonMappingParameters;

    private final CSVMappingParameters csvMappingParameters;

    private MappingParameters(BuilderImpl builder) {
        this.jsonMappingParameters = builder.jsonMappingParameters;
        this.csvMappingParameters = builder.csvMappingParameters;
    }

    /**
     * <p>
     * Provides additional mapping information when JSON is the record format on the streaming source.
     * </p>
     * 
     * @return Provides additional mapping information when JSON is the record format on the streaming source.
     */
    public JSONMappingParameters jsonMappingParameters() {
        return jsonMappingParameters;
    }

    /**
     * <p>
     * Provides additional mapping information when the record format uses delimiters (for example, CSV).
     * </p>
     * 
     * @return Provides additional mapping information when the record format uses delimiters (for example, CSV).
     */
    public CSVMappingParameters csvMappingParameters() {
        return csvMappingParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jsonMappingParameters());
        hashCode = 31 * hashCode + Objects.hashCode(csvMappingParameters());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MappingParameters)) {
            return false;
        }
        MappingParameters other = (MappingParameters) obj;
        return Objects.equals(jsonMappingParameters(), other.jsonMappingParameters())
                && Objects.equals(csvMappingParameters(), other.csvMappingParameters());
    }

    @Override
    public String toString() {
        return ToString.builder("MappingParameters").add("JSONMappingParameters", jsonMappingParameters())
                .add("CSVMappingParameters", csvMappingParameters()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JSONMappingParameters":
            return Optional.of(clazz.cast(jsonMappingParameters()));
        case "CSVMappingParameters":
            return Optional.of(clazz.cast(csvMappingParameters()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MappingParametersMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, MappingParameters> {
        /**
         * <p>
         * Provides additional mapping information when JSON is the record format on the streaming source.
         * </p>
         * 
         * @param jsonMappingParameters
         *        Provides additional mapping information when JSON is the record format on the streaming source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jsonMappingParameters(JSONMappingParameters jsonMappingParameters);

        /**
         * <p>
         * Provides additional mapping information when JSON is the record format on the streaming source.
         * </p>
         * This is a convenience that creates an instance of the {@link JSONMappingParameters.Builder} avoiding the need
         * to create one manually via {@link JSONMappingParameters#builder()}.
         *
         * When the {@link Consumer} completes, {@link JSONMappingParameters.Builder#build()} is called immediately and
         * its result is passed to {@link #jsonMappingParameters(JSONMappingParameters)}.
         * 
         * @param jsonMappingParameters
         *        a consumer that will call methods on {@link JSONMappingParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jsonMappingParameters(JSONMappingParameters)
         */
        default Builder jsonMappingParameters(Consumer<JSONMappingParameters.Builder> jsonMappingParameters) {
            return jsonMappingParameters(JSONMappingParameters.builder().apply(jsonMappingParameters).build());
        }

        /**
         * <p>
         * Provides additional mapping information when the record format uses delimiters (for example, CSV).
         * </p>
         * 
         * @param csvMappingParameters
         *        Provides additional mapping information when the record format uses delimiters (for example, CSV).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder csvMappingParameters(CSVMappingParameters csvMappingParameters);

        /**
         * <p>
         * Provides additional mapping information when the record format uses delimiters (for example, CSV).
         * </p>
         * This is a convenience that creates an instance of the {@link CSVMappingParameters.Builder} avoiding the need
         * to create one manually via {@link CSVMappingParameters#builder()}.
         *
         * When the {@link Consumer} completes, {@link CSVMappingParameters.Builder#build()} is called immediately and
         * its result is passed to {@link #csvMappingParameters(CSVMappingParameters)}.
         * 
         * @param csvMappingParameters
         *        a consumer that will call methods on {@link CSVMappingParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #csvMappingParameters(CSVMappingParameters)
         */
        default Builder csvMappingParameters(Consumer<CSVMappingParameters.Builder> csvMappingParameters) {
            return csvMappingParameters(CSVMappingParameters.builder().apply(csvMappingParameters).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private JSONMappingParameters jsonMappingParameters;

        private CSVMappingParameters csvMappingParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(MappingParameters model) {
            jsonMappingParameters(model.jsonMappingParameters);
            csvMappingParameters(model.csvMappingParameters);
        }

        public final JSONMappingParameters.Builder getJSONMappingParameters() {
            return jsonMappingParameters != null ? jsonMappingParameters.toBuilder() : null;
        }

        @Override
        public final Builder jsonMappingParameters(JSONMappingParameters jsonMappingParameters) {
            this.jsonMappingParameters = jsonMappingParameters;
            return this;
        }

        public final void setJSONMappingParameters(JSONMappingParameters.BuilderImpl jsonMappingParameters) {
            this.jsonMappingParameters = jsonMappingParameters != null ? jsonMappingParameters.build() : null;
        }

        public final CSVMappingParameters.Builder getCSVMappingParameters() {
            return csvMappingParameters != null ? csvMappingParameters.toBuilder() : null;
        }

        @Override
        public final Builder csvMappingParameters(CSVMappingParameters csvMappingParameters) {
            this.csvMappingParameters = csvMappingParameters;
            return this;
        }

        public final void setCSVMappingParameters(CSVMappingParameters.BuilderImpl csvMappingParameters) {
            this.csvMappingParameters = csvMappingParameters != null ? csvMappingParameters.build() : null;
        }

        @Override
        public MappingParameters build() {
            return new MappingParameters(this);
        }
    }
}
