/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.transform.ReferenceDataSourceUpdateMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * When you update a reference data source configuration for an application, this object provides all the updated values
 * (such as the source bucket name and object key name), the in-application table name that is created, and updated
 * mapping information that maps the data in the Amazon S3 object to the in-application reference table that is created.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ReferenceDataSourceUpdate implements StructuredPojo,
        ToCopyableBuilder<ReferenceDataSourceUpdate.Builder, ReferenceDataSourceUpdate> {
    private final String referenceId;

    private final String tableNameUpdate;

    private final S3ReferenceDataSourceUpdate s3ReferenceDataSourceUpdate;

    private final SourceSchema referenceSchemaUpdate;

    private ReferenceDataSourceUpdate(BuilderImpl builder) {
        this.referenceId = builder.referenceId;
        this.tableNameUpdate = builder.tableNameUpdate;
        this.s3ReferenceDataSourceUpdate = builder.s3ReferenceDataSourceUpdate;
        this.referenceSchemaUpdate = builder.referenceSchemaUpdate;
    }

    /**
     * <p>
     * ID of the reference data source being updated. You can use the <a>DescribeApplication</a> operation to get this
     * value.
     * </p>
     * 
     * @return ID of the reference data source being updated. You can use the <a>DescribeApplication</a> operation to
     *         get this value.
     */
    public String referenceId() {
        return referenceId;
    }

    /**
     * <p>
     * In-application table name that is created by this update.
     * </p>
     * 
     * @return In-application table name that is created by this update.
     */
    public String tableNameUpdate() {
        return tableNameUpdate;
    }

    /**
     * <p>
     * Describes the S3 bucket name, object key name, and IAM role that Amazon Kinesis Analytics can assume to read the
     * Amazon S3 object on your behalf and populate the in-application reference table.
     * </p>
     * 
     * @return Describes the S3 bucket name, object key name, and IAM role that Amazon Kinesis Analytics can assume to
     *         read the Amazon S3 object on your behalf and populate the in-application reference table.
     */
    public S3ReferenceDataSourceUpdate s3ReferenceDataSourceUpdate() {
        return s3ReferenceDataSourceUpdate;
    }

    /**
     * Returns the value of the ReferenceSchemaUpdate property for this object.
     * 
     * @return The value of the ReferenceSchemaUpdate property for this object.
     */
    public SourceSchema referenceSchemaUpdate() {
        return referenceSchemaUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(referenceId());
        hashCode = 31 * hashCode + Objects.hashCode(tableNameUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(s3ReferenceDataSourceUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(referenceSchemaUpdate());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReferenceDataSourceUpdate)) {
            return false;
        }
        ReferenceDataSourceUpdate other = (ReferenceDataSourceUpdate) obj;
        return Objects.equals(referenceId(), other.referenceId()) && Objects.equals(tableNameUpdate(), other.tableNameUpdate())
                && Objects.equals(s3ReferenceDataSourceUpdate(), other.s3ReferenceDataSourceUpdate())
                && Objects.equals(referenceSchemaUpdate(), other.referenceSchemaUpdate());
    }

    @Override
    public String toString() {
        return ToString.builder("ReferenceDataSourceUpdate").add("ReferenceId", referenceId())
                .add("TableNameUpdate", tableNameUpdate()).add("S3ReferenceDataSourceUpdate", s3ReferenceDataSourceUpdate())
                .add("ReferenceSchemaUpdate", referenceSchemaUpdate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReferenceId":
            return Optional.of(clazz.cast(referenceId()));
        case "TableNameUpdate":
            return Optional.of(clazz.cast(tableNameUpdate()));
        case "S3ReferenceDataSourceUpdate":
            return Optional.of(clazz.cast(s3ReferenceDataSourceUpdate()));
        case "ReferenceSchemaUpdate":
            return Optional.of(clazz.cast(referenceSchemaUpdate()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ReferenceDataSourceUpdateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ReferenceDataSourceUpdate> {
        /**
         * <p>
         * ID of the reference data source being updated. You can use the <a>DescribeApplication</a> operation to get
         * this value.
         * </p>
         * 
         * @param referenceId
         *        ID of the reference data source being updated. You can use the <a>DescribeApplication</a> operation to
         *        get this value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referenceId(String referenceId);

        /**
         * <p>
         * In-application table name that is created by this update.
         * </p>
         * 
         * @param tableNameUpdate
         *        In-application table name that is created by this update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableNameUpdate(String tableNameUpdate);

        /**
         * <p>
         * Describes the S3 bucket name, object key name, and IAM role that Amazon Kinesis Analytics can assume to read
         * the Amazon S3 object on your behalf and populate the in-application reference table.
         * </p>
         * 
         * @param s3ReferenceDataSourceUpdate
         *        Describes the S3 bucket name, object key name, and IAM role that Amazon Kinesis Analytics can assume
         *        to read the Amazon S3 object on your behalf and populate the in-application reference table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3ReferenceDataSourceUpdate(S3ReferenceDataSourceUpdate s3ReferenceDataSourceUpdate);

        /**
         * <p>
         * Describes the S3 bucket name, object key name, and IAM role that Amazon Kinesis Analytics can assume to read
         * the Amazon S3 object on your behalf and populate the in-application reference table.
         * </p>
         * This is a convenience that creates an instance of the {@link S3ReferenceDataSourceUpdate.Builder} avoiding
         * the need to create one manually via {@link S3ReferenceDataSourceUpdate#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3ReferenceDataSourceUpdate.Builder#build()} is called
         * immediately and its result is passed to {@link #s3ReferenceDataSourceUpdate(S3ReferenceDataSourceUpdate)}.
         * 
         * @param s3ReferenceDataSourceUpdate
         *        a consumer that will call methods on {@link S3ReferenceDataSourceUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3ReferenceDataSourceUpdate(S3ReferenceDataSourceUpdate)
         */
        default Builder s3ReferenceDataSourceUpdate(Consumer<S3ReferenceDataSourceUpdate.Builder> s3ReferenceDataSourceUpdate) {
            return s3ReferenceDataSourceUpdate(S3ReferenceDataSourceUpdate.builder().apply(s3ReferenceDataSourceUpdate).build());
        }

        /**
         * Sets the value of the ReferenceSchemaUpdate property for this object.
         *
         * @param referenceSchemaUpdate
         *        The new value for the ReferenceSchemaUpdate property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referenceSchemaUpdate(SourceSchema referenceSchemaUpdate);

        /**
         * Sets the value of the ReferenceSchemaUpdate property for this object.
         *
         * This is a convenience that creates an instance of the {@link SourceSchema.Builder} avoiding the need to
         * create one manually via {@link SourceSchema#builder()}.
         *
         * When the {@link Consumer} completes, {@link SourceSchema.Builder#build()} is called immediately and its
         * result is passed to {@link #referenceSchemaUpdate(SourceSchema)}.
         * 
         * @param referenceSchemaUpdate
         *        a consumer that will call methods on {@link SourceSchema.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #referenceSchemaUpdate(SourceSchema)
         */
        default Builder referenceSchemaUpdate(Consumer<SourceSchema.Builder> referenceSchemaUpdate) {
            return referenceSchemaUpdate(SourceSchema.builder().apply(referenceSchemaUpdate).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String referenceId;

        private String tableNameUpdate;

        private S3ReferenceDataSourceUpdate s3ReferenceDataSourceUpdate;

        private SourceSchema referenceSchemaUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(ReferenceDataSourceUpdate model) {
            referenceId(model.referenceId);
            tableNameUpdate(model.tableNameUpdate);
            s3ReferenceDataSourceUpdate(model.s3ReferenceDataSourceUpdate);
            referenceSchemaUpdate(model.referenceSchemaUpdate);
        }

        public final String getReferenceId() {
            return referenceId;
        }

        @Override
        public final Builder referenceId(String referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        public final void setReferenceId(String referenceId) {
            this.referenceId = referenceId;
        }

        public final String getTableNameUpdate() {
            return tableNameUpdate;
        }

        @Override
        public final Builder tableNameUpdate(String tableNameUpdate) {
            this.tableNameUpdate = tableNameUpdate;
            return this;
        }

        public final void setTableNameUpdate(String tableNameUpdate) {
            this.tableNameUpdate = tableNameUpdate;
        }

        public final S3ReferenceDataSourceUpdate.Builder getS3ReferenceDataSourceUpdate() {
            return s3ReferenceDataSourceUpdate != null ? s3ReferenceDataSourceUpdate.toBuilder() : null;
        }

        @Override
        public final Builder s3ReferenceDataSourceUpdate(S3ReferenceDataSourceUpdate s3ReferenceDataSourceUpdate) {
            this.s3ReferenceDataSourceUpdate = s3ReferenceDataSourceUpdate;
            return this;
        }

        public final void setS3ReferenceDataSourceUpdate(S3ReferenceDataSourceUpdate.BuilderImpl s3ReferenceDataSourceUpdate) {
            this.s3ReferenceDataSourceUpdate = s3ReferenceDataSourceUpdate != null ? s3ReferenceDataSourceUpdate.build() : null;
        }

        public final SourceSchema.Builder getReferenceSchemaUpdate() {
            return referenceSchemaUpdate != null ? referenceSchemaUpdate.toBuilder() : null;
        }

        @Override
        public final Builder referenceSchemaUpdate(SourceSchema referenceSchemaUpdate) {
            this.referenceSchemaUpdate = referenceSchemaUpdate;
            return this;
        }

        public final void setReferenceSchemaUpdate(SourceSchema.BuilderImpl referenceSchemaUpdate) {
            this.referenceSchemaUpdate = referenceSchemaUpdate != null ? referenceSchemaUpdate.build() : null;
        }

        @Override
        public ReferenceDataSourceUpdate build() {
            return new ReferenceDataSourceUpdate(this);
        }
    }
}
