/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum DeliveryStreamType {
    DIRECT_PUT("DirectPut"),
    KINESIS_STREAM_ASSOURCE("KinesisStreamAsSource"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private DeliveryStreamType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DeliveryStreamType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(DeliveryStreamType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DeliveryStreamType> knownValues() {
        return Stream.of(DeliveryStreamType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

