/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.firehose.transform.RecordMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Record
implements StructuredPojo,
ToCopyableBuilder<Builder, Record> {
    private final ByteBuffer data;

    private Record(BuilderImpl builder) {
        this.data = builder.data;
    }

    public ByteBuffer data() {
        return this.data == null ? null : this.data.asReadOnlyBuffer();
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.data());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Record)) {
            return false;
        }
        Record other = (Record)obj;
        return Objects.equals(this.data(), other.data());
    }

    public String toString() {
        return ToString.builder((String)"Record").add("Data", (Object)this.data()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Data": {
                return Optional.of(clazz.cast(this.data()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RecordMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private ByteBuffer data;

        private BuilderImpl() {
        }

        private BuilderImpl(Record model) {
            this.data(model.data);
        }

        public final ByteBuffer getData() {
            return this.data;
        }

        @Override
        public final Builder data(ByteBuffer data) {
            this.data = StandardMemberCopier.copy((ByteBuffer)data);
            return this;
        }

        public final void setData(ByteBuffer data) {
            this.data = StandardMemberCopier.copy((ByteBuffer)data);
        }

        public Record build() {
            return new Record(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Record> {
        public Builder data(ByteBuffer var1);
    }
}

