/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.firehose.model.CreateDeliveryStreamRequest;

@SdkInternalApi
public class CreateDeliveryStreamRequestModelMarshaller {
    private static final MarshallingInfo<String> DELIVERYSTREAMNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeliveryStreamName").build();
    private static final MarshallingInfo<String> DELIVERYSTREAMTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeliveryStreamType").build();
    private static final MarshallingInfo<StructuredPojo> KINESISSTREAMSOURCECONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KinesisStreamSourceConfiguration").build();
    private static final MarshallingInfo<StructuredPojo> S3DESTINATIONCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3DestinationConfiguration").build();
    private static final MarshallingInfo<StructuredPojo> EXTENDEDS3DESTINATIONCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExtendedS3DestinationConfiguration").build();
    private static final MarshallingInfo<StructuredPojo> REDSHIFTDESTINATIONCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RedshiftDestinationConfiguration").build();
    private static final MarshallingInfo<StructuredPojo> ELASTICSEARCHDESTINATIONCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ElasticsearchDestinationConfiguration").build();
    private static final MarshallingInfo<StructuredPojo> SPLUNKDESTINATIONCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SplunkDestinationConfiguration").build();
    private static final CreateDeliveryStreamRequestModelMarshaller INSTANCE = new CreateDeliveryStreamRequestModelMarshaller();

    public static CreateDeliveryStreamRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateDeliveryStreamRequest createDeliveryStreamRequest, ProtocolMarshaller protocolMarshaller) {
        if (createDeliveryStreamRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)createDeliveryStreamRequest.deliveryStreamName(), DELIVERYSTREAMNAME_BINDING);
            protocolMarshaller.marshall((Object)createDeliveryStreamRequest.deliveryStreamTypeString(), DELIVERYSTREAMTYPE_BINDING);
            protocolMarshaller.marshall((Object)createDeliveryStreamRequest.kinesisStreamSourceConfiguration(), KINESISSTREAMSOURCECONFIGURATION_BINDING);
            protocolMarshaller.marshall((Object)createDeliveryStreamRequest.s3DestinationConfiguration(), S3DESTINATIONCONFIGURATION_BINDING);
            protocolMarshaller.marshall((Object)createDeliveryStreamRequest.extendedS3DestinationConfiguration(), EXTENDEDS3DESTINATIONCONFIGURATION_BINDING);
            protocolMarshaller.marshall((Object)createDeliveryStreamRequest.redshiftDestinationConfiguration(), REDSHIFTDESTINATIONCONFIGURATION_BINDING);
            protocolMarshaller.marshall((Object)createDeliveryStreamRequest.elasticsearchDestinationConfiguration(), ELASTICSEARCHDESTINATIONCONFIGURATION_BINDING);
            protocolMarshaller.marshall((Object)createDeliveryStreamRequest.splunkDestinationConfiguration(), SPLUNKDESTINATIONCONFIGURATION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

