/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.transform;

import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.firehose.model.ElasticsearchDestinationUpdate;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link ElasticsearchDestinationUpdate} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class ElasticsearchDestinationUpdateMarshaller {
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RoleARN").isBinary(false).build();

    private static final MarshallingInfo<String> DOMAINARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DomainARN").isBinary(false).build();

    private static final MarshallingInfo<String> INDEXNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IndexName").isBinary(false).build();

    private static final MarshallingInfo<String> TYPENAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TypeName").isBinary(false).build();

    private static final MarshallingInfo<String> INDEXROTATIONPERIOD_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IndexRotationPeriod").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> BUFFERINGHINTS_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("BufferingHints").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> RETRYOPTIONS_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RetryOptions")
            .isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> S3UPDATE_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3Update").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> PROCESSINGCONFIGURATION_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("ProcessingConfiguration").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> CLOUDWATCHLOGGINGOPTIONS_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("CloudWatchLoggingOptions").isBinary(false).build();

    private static final ElasticsearchDestinationUpdateMarshaller INSTANCE = new ElasticsearchDestinationUpdateMarshaller();

    private ElasticsearchDestinationUpdateMarshaller() {
    }

    public static ElasticsearchDestinationUpdateMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(ElasticsearchDestinationUpdate elasticsearchDestinationUpdate, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(elasticsearchDestinationUpdate, "elasticsearchDestinationUpdate");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(elasticsearchDestinationUpdate.roleARN(), ROLEARN_BINDING);
            protocolMarshaller.marshall(elasticsearchDestinationUpdate.domainARN(), DOMAINARN_BINDING);
            protocolMarshaller.marshall(elasticsearchDestinationUpdate.indexName(), INDEXNAME_BINDING);
            protocolMarshaller.marshall(elasticsearchDestinationUpdate.typeName(), TYPENAME_BINDING);
            protocolMarshaller.marshall(elasticsearchDestinationUpdate.indexRotationPeriodString(), INDEXROTATIONPERIOD_BINDING);
            protocolMarshaller.marshall(elasticsearchDestinationUpdate.bufferingHints(), BUFFERINGHINTS_BINDING);
            protocolMarshaller.marshall(elasticsearchDestinationUpdate.retryOptions(), RETRYOPTIONS_BINDING);
            protocolMarshaller.marshall(elasticsearchDestinationUpdate.s3Update(), S3UPDATE_BINDING);
            protocolMarshaller
                    .marshall(elasticsearchDestinationUpdate.processingConfiguration(), PROCESSINGCONFIGURATION_BINDING);
            protocolMarshaller.marshall(elasticsearchDestinationUpdate.cloudWatchLoggingOptions(),
                    CLOUDWATCHLOGGINGOPTIONS_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
