/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.transform.ApplicationSummaryMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides application summary information, including the application Amazon Resource Name (ARN), name, and status.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ApplicationSummary implements StructuredPojo, ToCopyableBuilder<ApplicationSummary.Builder, ApplicationSummary> {
    private final String applicationName;

    private final String applicationARN;

    private final String applicationStatus;

    private ApplicationSummary(BuilderImpl builder) {
        this.applicationName = builder.applicationName;
        this.applicationARN = builder.applicationARN;
        this.applicationStatus = builder.applicationStatus;
    }

    /**
     * <p>
     * Name of the application.
     * </p>
     * 
     * @return Name of the application.
     */
    public String applicationName() {
        return applicationName;
    }

    /**
     * <p>
     * ARN of the application.
     * </p>
     * 
     * @return ARN of the application.
     */
    public String applicationARN() {
        return applicationARN;
    }

    /**
     * <p>
     * Status of the application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #applicationStatus}
     * will return {@link ApplicationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #applicationStatusString}.
     * </p>
     * 
     * @return Status of the application.
     * @see ApplicationStatus
     */
    public ApplicationStatus applicationStatus() {
        return ApplicationStatus.fromValue(applicationStatus);
    }

    /**
     * <p>
     * Status of the application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #applicationStatus}
     * will return {@link ApplicationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #applicationStatusString}.
     * </p>
     * 
     * @return Status of the application.
     * @see ApplicationStatus
     */
    public String applicationStatusString() {
        return applicationStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(applicationARN());
        hashCode = 31 * hashCode + Objects.hashCode(applicationStatusString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationSummary)) {
            return false;
        }
        ApplicationSummary other = (ApplicationSummary) obj;
        return Objects.equals(applicationName(), other.applicationName())
                && Objects.equals(applicationARN(), other.applicationARN())
                && Objects.equals(applicationStatusString(), other.applicationStatusString());
    }

    @Override
    public String toString() {
        return ToString.builder("ApplicationSummary").add("ApplicationName", applicationName())
                .add("ApplicationARN", applicationARN()).add("ApplicationStatus", applicationStatusString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationName":
            return Optional.of(clazz.cast(applicationName()));
        case "ApplicationARN":
            return Optional.of(clazz.cast(applicationARN()));
        case "ApplicationStatus":
            return Optional.of(clazz.cast(applicationStatusString()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ApplicationSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ApplicationSummary> {
        /**
         * <p>
         * Name of the application.
         * </p>
         * 
         * @param applicationName
         *        Name of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationName(String applicationName);

        /**
         * <p>
         * ARN of the application.
         * </p>
         * 
         * @param applicationARN
         *        ARN of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationARN(String applicationARN);

        /**
         * <p>
         * Status of the application.
         * </p>
         * 
         * @param applicationStatus
         *        Status of the application.
         * @see ApplicationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationStatus
         */
        Builder applicationStatus(String applicationStatus);

        /**
         * <p>
         * Status of the application.
         * </p>
         * 
         * @param applicationStatus
         *        Status of the application.
         * @see ApplicationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationStatus
         */
        Builder applicationStatus(ApplicationStatus applicationStatus);
    }

    static final class BuilderImpl implements Builder {
        private String applicationName;

        private String applicationARN;

        private String applicationStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationSummary model) {
            applicationName(model.applicationName);
            applicationARN(model.applicationARN);
            applicationStatus(model.applicationStatus);
        }

        public final String getApplicationName() {
            return applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final String getApplicationARN() {
            return applicationARN;
        }

        @Override
        public final Builder applicationARN(String applicationARN) {
            this.applicationARN = applicationARN;
            return this;
        }

        public final void setApplicationARN(String applicationARN) {
            this.applicationARN = applicationARN;
        }

        public final String getApplicationStatus() {
            return applicationStatus;
        }

        @Override
        public final Builder applicationStatus(String applicationStatus) {
            this.applicationStatus = applicationStatus;
            return this;
        }

        @Override
        public final Builder applicationStatus(ApplicationStatus applicationStatus) {
            this.applicationStatus(applicationStatus.toString());
            return this;
        }

        public final void setApplicationStatus(String applicationStatus) {
            this.applicationStatus = applicationStatus;
        }

        @Override
        public ApplicationSummary build() {
            return new ApplicationSummary(this);
        }
    }
}
