/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.transform.CloudWatchLoggingOptionUpdateMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes CloudWatch logging option updates.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CloudWatchLoggingOptionUpdate implements StructuredPojo,
        ToCopyableBuilder<CloudWatchLoggingOptionUpdate.Builder, CloudWatchLoggingOptionUpdate> {
    private final String cloudWatchLoggingOptionId;

    private final String logStreamARNUpdate;

    private final String roleARNUpdate;

    private CloudWatchLoggingOptionUpdate(BuilderImpl builder) {
        this.cloudWatchLoggingOptionId = builder.cloudWatchLoggingOptionId;
        this.logStreamARNUpdate = builder.logStreamARNUpdate;
        this.roleARNUpdate = builder.roleARNUpdate;
    }

    /**
     * <p>
     * ID of the CloudWatch logging option to update
     * </p>
     * 
     * @return ID of the CloudWatch logging option to update
     */
    public String cloudWatchLoggingOptionId() {
        return cloudWatchLoggingOptionId;
    }

    /**
     * <p>
     * ARN of the CloudWatch log to receive application messages.
     * </p>
     * 
     * @return ARN of the CloudWatch log to receive application messages.
     */
    public String logStreamARNUpdate() {
        return logStreamARNUpdate;
    }

    /**
     * <p>
     * IAM ARN of the role to use to send application messages. Note: To write application messages to CloudWatch, the
     * IAM role used must have the <code>PutLogEvents</code> policy action enabled.
     * </p>
     * 
     * @return IAM ARN of the role to use to send application messages. Note: To write application messages to
     *         CloudWatch, the IAM role used must have the <code>PutLogEvents</code> policy action enabled.
     */
    public String roleARNUpdate() {
        return roleARNUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchLoggingOptionId());
        hashCode = 31 * hashCode + Objects.hashCode(logStreamARNUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(roleARNUpdate());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudWatchLoggingOptionUpdate)) {
            return false;
        }
        CloudWatchLoggingOptionUpdate other = (CloudWatchLoggingOptionUpdate) obj;
        return Objects.equals(cloudWatchLoggingOptionId(), other.cloudWatchLoggingOptionId())
                && Objects.equals(logStreamARNUpdate(), other.logStreamARNUpdate())
                && Objects.equals(roleARNUpdate(), other.roleARNUpdate());
    }

    @Override
    public String toString() {
        return ToString.builder("CloudWatchLoggingOptionUpdate").add("CloudWatchLoggingOptionId", cloudWatchLoggingOptionId())
                .add("LogStreamARNUpdate", logStreamARNUpdate()).add("RoleARNUpdate", roleARNUpdate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CloudWatchLoggingOptionId":
            return Optional.of(clazz.cast(cloudWatchLoggingOptionId()));
        case "LogStreamARNUpdate":
            return Optional.of(clazz.cast(logStreamARNUpdate()));
        case "RoleARNUpdate":
            return Optional.of(clazz.cast(roleARNUpdate()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CloudWatchLoggingOptionUpdateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, CloudWatchLoggingOptionUpdate> {
        /**
         * <p>
         * ID of the CloudWatch logging option to update
         * </p>
         * 
         * @param cloudWatchLoggingOptionId
         *        ID of the CloudWatch logging option to update
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLoggingOptionId(String cloudWatchLoggingOptionId);

        /**
         * <p>
         * ARN of the CloudWatch log to receive application messages.
         * </p>
         * 
         * @param logStreamARNUpdate
         *        ARN of the CloudWatch log to receive application messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logStreamARNUpdate(String logStreamARNUpdate);

        /**
         * <p>
         * IAM ARN of the role to use to send application messages. Note: To write application messages to CloudWatch,
         * the IAM role used must have the <code>PutLogEvents</code> policy action enabled.
         * </p>
         * 
         * @param roleARNUpdate
         *        IAM ARN of the role to use to send application messages. Note: To write application messages to
         *        CloudWatch, the IAM role used must have the <code>PutLogEvents</code> policy action enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleARNUpdate(String roleARNUpdate);
    }

    static final class BuilderImpl implements Builder {
        private String cloudWatchLoggingOptionId;

        private String logStreamARNUpdate;

        private String roleARNUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudWatchLoggingOptionUpdate model) {
            cloudWatchLoggingOptionId(model.cloudWatchLoggingOptionId);
            logStreamARNUpdate(model.logStreamARNUpdate);
            roleARNUpdate(model.roleARNUpdate);
        }

        public final String getCloudWatchLoggingOptionId() {
            return cloudWatchLoggingOptionId;
        }

        @Override
        public final Builder cloudWatchLoggingOptionId(String cloudWatchLoggingOptionId) {
            this.cloudWatchLoggingOptionId = cloudWatchLoggingOptionId;
            return this;
        }

        public final void setCloudWatchLoggingOptionId(String cloudWatchLoggingOptionId) {
            this.cloudWatchLoggingOptionId = cloudWatchLoggingOptionId;
        }

        public final String getLogStreamARNUpdate() {
            return logStreamARNUpdate;
        }

        @Override
        public final Builder logStreamARNUpdate(String logStreamARNUpdate) {
            this.logStreamARNUpdate = logStreamARNUpdate;
            return this;
        }

        public final void setLogStreamARNUpdate(String logStreamARNUpdate) {
            this.logStreamARNUpdate = logStreamARNUpdate;
        }

        public final String getRoleARNUpdate() {
            return roleARNUpdate;
        }

        @Override
        public final Builder roleARNUpdate(String roleARNUpdate) {
            this.roleARNUpdate = roleARNUpdate;
            return this;
        }

        public final void setRoleARNUpdate(String roleARNUpdate) {
            this.roleARNUpdate = roleARNUpdate;
        }

        @Override
        public CloudWatchLoggingOptionUpdate build() {
            return new CloudWatchLoggingOptionUpdate(this);
        }
    }
}
