/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.transform.InputProcessingConfigurationDescriptionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides configuration information about an input processor. Currently, the only input processor available is <a
 * href="https://aws.amazon.com/documentation/lambda/">AWS Lambda</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class InputProcessingConfigurationDescription implements StructuredPojo,
        ToCopyableBuilder<InputProcessingConfigurationDescription.Builder, InputProcessingConfigurationDescription> {
    private final InputLambdaProcessorDescription inputLambdaProcessorDescription;

    private InputProcessingConfigurationDescription(BuilderImpl builder) {
        this.inputLambdaProcessorDescription = builder.inputLambdaProcessorDescription;
    }

    /**
     * <p>
     * Provides configuration information about the associated <a>InputLambdaProcessorDescription</a>.
     * </p>
     * 
     * @return Provides configuration information about the associated <a>InputLambdaProcessorDescription</a>.
     */
    public InputLambdaProcessorDescription inputLambdaProcessorDescription() {
        return inputLambdaProcessorDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(inputLambdaProcessorDescription());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputProcessingConfigurationDescription)) {
            return false;
        }
        InputProcessingConfigurationDescription other = (InputProcessingConfigurationDescription) obj;
        return Objects.equals(inputLambdaProcessorDescription(), other.inputLambdaProcessorDescription());
    }

    @Override
    public String toString() {
        return ToString.builder("InputProcessingConfigurationDescription")
                .add("InputLambdaProcessorDescription", inputLambdaProcessorDescription()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InputLambdaProcessorDescription":
            return Optional.of(clazz.cast(inputLambdaProcessorDescription()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InputProcessingConfigurationDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, InputProcessingConfigurationDescription> {
        /**
         * <p>
         * Provides configuration information about the associated <a>InputLambdaProcessorDescription</a>.
         * </p>
         * 
         * @param inputLambdaProcessorDescription
         *        Provides configuration information about the associated <a>InputLambdaProcessorDescription</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputLambdaProcessorDescription(InputLambdaProcessorDescription inputLambdaProcessorDescription);

        /**
         * <p>
         * Provides configuration information about the associated <a>InputLambdaProcessorDescription</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link InputLambdaProcessorDescription.Builder}
         * avoiding the need to create one manually via {@link InputLambdaProcessorDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link InputLambdaProcessorDescription.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #inputLambdaProcessorDescription(InputLambdaProcessorDescription)}.
         * 
         * @param inputLambdaProcessorDescription
         *        a consumer that will call methods on {@link InputLambdaProcessorDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputLambdaProcessorDescription(InputLambdaProcessorDescription)
         */
        default Builder inputLambdaProcessorDescription(
                Consumer<InputLambdaProcessorDescription.Builder> inputLambdaProcessorDescription) {
            return inputLambdaProcessorDescription(InputLambdaProcessorDescription.builder()
                    .apply(inputLambdaProcessorDescription).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private InputLambdaProcessorDescription inputLambdaProcessorDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(InputProcessingConfigurationDescription model) {
            inputLambdaProcessorDescription(model.inputLambdaProcessorDescription);
        }

        public final InputLambdaProcessorDescription.Builder getInputLambdaProcessorDescription() {
            return inputLambdaProcessorDescription != null ? inputLambdaProcessorDescription.toBuilder() : null;
        }

        @Override
        public final Builder inputLambdaProcessorDescription(InputLambdaProcessorDescription inputLambdaProcessorDescription) {
            this.inputLambdaProcessorDescription = inputLambdaProcessorDescription;
            return this;
        }

        public final void setInputLambdaProcessorDescription(
                InputLambdaProcessorDescription.BuilderImpl inputLambdaProcessorDescription) {
            this.inputLambdaProcessorDescription = inputLambdaProcessorDescription != null ? inputLambdaProcessorDescription
                    .build() : null;
        }

        @Override
        public InputProcessingConfigurationDescription build() {
            return new InputProcessingConfigurationDescription(this);
        }
    }
}
