/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.transform.RecordFormatMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the record format and relevant mapping information that should be applied to schematize the records on the
 * stream.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class RecordFormat implements StructuredPojo, ToCopyableBuilder<RecordFormat.Builder, RecordFormat> {
    private final String recordFormatType;

    private final MappingParameters mappingParameters;

    private RecordFormat(BuilderImpl builder) {
        this.recordFormatType = builder.recordFormatType;
        this.mappingParameters = builder.mappingParameters;
    }

    /**
     * <p>
     * The type of record format.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #recordFormatType}
     * will return {@link RecordFormatType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #recordFormatTypeString}.
     * </p>
     * 
     * @return The type of record format.
     * @see RecordFormatType
     */
    public RecordFormatType recordFormatType() {
        return RecordFormatType.fromValue(recordFormatType);
    }

    /**
     * <p>
     * The type of record format.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #recordFormatType}
     * will return {@link RecordFormatType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #recordFormatTypeString}.
     * </p>
     * 
     * @return The type of record format.
     * @see RecordFormatType
     */
    public String recordFormatTypeString() {
        return recordFormatType;
    }

    /**
     * Returns the value of the MappingParameters property for this object.
     * 
     * @return The value of the MappingParameters property for this object.
     */
    public MappingParameters mappingParameters() {
        return mappingParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(recordFormatTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(mappingParameters());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecordFormat)) {
            return false;
        }
        RecordFormat other = (RecordFormat) obj;
        return Objects.equals(recordFormatTypeString(), other.recordFormatTypeString())
                && Objects.equals(mappingParameters(), other.mappingParameters());
    }

    @Override
    public String toString() {
        return ToString.builder("RecordFormat").add("RecordFormatType", recordFormatTypeString())
                .add("MappingParameters", mappingParameters()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RecordFormatType":
            return Optional.of(clazz.cast(recordFormatTypeString()));
        case "MappingParameters":
            return Optional.of(clazz.cast(mappingParameters()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RecordFormatMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, RecordFormat> {
        /**
         * <p>
         * The type of record format.
         * </p>
         * 
         * @param recordFormatType
         *        The type of record format.
         * @see RecordFormatType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecordFormatType
         */
        Builder recordFormatType(String recordFormatType);

        /**
         * <p>
         * The type of record format.
         * </p>
         * 
         * @param recordFormatType
         *        The type of record format.
         * @see RecordFormatType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecordFormatType
         */
        Builder recordFormatType(RecordFormatType recordFormatType);

        /**
         * Sets the value of the MappingParameters property for this object.
         *
         * @param mappingParameters
         *        The new value for the MappingParameters property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mappingParameters(MappingParameters mappingParameters);

        /**
         * Sets the value of the MappingParameters property for this object.
         *
         * This is a convenience that creates an instance of the {@link MappingParameters.Builder} avoiding the need to
         * create one manually via {@link MappingParameters#builder()}.
         *
         * When the {@link Consumer} completes, {@link MappingParameters.Builder#build()} is called immediately and its
         * result is passed to {@link #mappingParameters(MappingParameters)}.
         * 
         * @param mappingParameters
         *        a consumer that will call methods on {@link MappingParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mappingParameters(MappingParameters)
         */
        default Builder mappingParameters(Consumer<MappingParameters.Builder> mappingParameters) {
            return mappingParameters(MappingParameters.builder().apply(mappingParameters).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String recordFormatType;

        private MappingParameters mappingParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(RecordFormat model) {
            recordFormatType(model.recordFormatType);
            mappingParameters(model.mappingParameters);
        }

        public final String getRecordFormatType() {
            return recordFormatType;
        }

        @Override
        public final Builder recordFormatType(String recordFormatType) {
            this.recordFormatType = recordFormatType;
            return this;
        }

        @Override
        public final Builder recordFormatType(RecordFormatType recordFormatType) {
            this.recordFormatType(recordFormatType.toString());
            return this;
        }

        public final void setRecordFormatType(String recordFormatType) {
            this.recordFormatType = recordFormatType;
        }

        public final MappingParameters.Builder getMappingParameters() {
            return mappingParameters != null ? mappingParameters.toBuilder() : null;
        }

        @Override
        public final Builder mappingParameters(MappingParameters mappingParameters) {
            this.mappingParameters = mappingParameters;
            return this;
        }

        public final void setMappingParameters(MappingParameters.BuilderImpl mappingParameters) {
            this.mappingParameters = mappingParameters != null ? mappingParameters.build() : null;
        }

        @Override
        public RecordFormat build() {
            return new RecordFormat(this);
        }
    }
}
