/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.transform.S3ReferenceDataSourceDescriptionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the bucket name and object key name that stores the reference data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class S3ReferenceDataSourceDescription implements StructuredPojo,
        ToCopyableBuilder<S3ReferenceDataSourceDescription.Builder, S3ReferenceDataSourceDescription> {
    private final String bucketARN;

    private final String fileKey;

    private final String referenceRoleARN;

    private S3ReferenceDataSourceDescription(BuilderImpl builder) {
        this.bucketARN = builder.bucketARN;
        this.fileKey = builder.fileKey;
        this.referenceRoleARN = builder.referenceRoleARN;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of the S3 bucket.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of the S3 bucket.
     */
    public String bucketARN() {
        return bucketARN;
    }

    /**
     * <p>
     * Amazon S3 object key name.
     * </p>
     * 
     * @return Amazon S3 object key name.
     */
    public String fileKey() {
        return fileKey;
    }

    /**
     * <p>
     * ARN of the IAM role that Amazon Kinesis Analytics can assume to read the Amazon S3 object on your behalf to
     * populate the in-application reference table.
     * </p>
     * 
     * @return ARN of the IAM role that Amazon Kinesis Analytics can assume to read the Amazon S3 object on your behalf
     *         to populate the in-application reference table.
     */
    public String referenceRoleARN() {
        return referenceRoleARN;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bucketARN());
        hashCode = 31 * hashCode + Objects.hashCode(fileKey());
        hashCode = 31 * hashCode + Objects.hashCode(referenceRoleARN());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3ReferenceDataSourceDescription)) {
            return false;
        }
        S3ReferenceDataSourceDescription other = (S3ReferenceDataSourceDescription) obj;
        return Objects.equals(bucketARN(), other.bucketARN()) && Objects.equals(fileKey(), other.fileKey())
                && Objects.equals(referenceRoleARN(), other.referenceRoleARN());
    }

    @Override
    public String toString() {
        return ToString.builder("S3ReferenceDataSourceDescription").add("BucketARN", bucketARN()).add("FileKey", fileKey())
                .add("ReferenceRoleARN", referenceRoleARN()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BucketARN":
            return Optional.of(clazz.cast(bucketARN()));
        case "FileKey":
            return Optional.of(clazz.cast(fileKey()));
        case "ReferenceRoleARN":
            return Optional.of(clazz.cast(referenceRoleARN()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        S3ReferenceDataSourceDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, S3ReferenceDataSourceDescription> {
        /**
         * <p>
         * Amazon Resource Name (ARN) of the S3 bucket.
         * </p>
         * 
         * @param bucketARN
         *        Amazon Resource Name (ARN) of the S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketARN(String bucketARN);

        /**
         * <p>
         * Amazon S3 object key name.
         * </p>
         * 
         * @param fileKey
         *        Amazon S3 object key name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileKey(String fileKey);

        /**
         * <p>
         * ARN of the IAM role that Amazon Kinesis Analytics can assume to read the Amazon S3 object on your behalf to
         * populate the in-application reference table.
         * </p>
         * 
         * @param referenceRoleARN
         *        ARN of the IAM role that Amazon Kinesis Analytics can assume to read the Amazon S3 object on your
         *        behalf to populate the in-application reference table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referenceRoleARN(String referenceRoleARN);
    }

    static final class BuilderImpl implements Builder {
        private String bucketARN;

        private String fileKey;

        private String referenceRoleARN;

        private BuilderImpl() {
        }

        private BuilderImpl(S3ReferenceDataSourceDescription model) {
            bucketARN(model.bucketARN);
            fileKey(model.fileKey);
            referenceRoleARN(model.referenceRoleARN);
        }

        public final String getBucketARN() {
            return bucketARN;
        }

        @Override
        public final Builder bucketARN(String bucketARN) {
            this.bucketARN = bucketARN;
            return this;
        }

        public final void setBucketARN(String bucketARN) {
            this.bucketARN = bucketARN;
        }

        public final String getFileKey() {
            return fileKey;
        }

        @Override
        public final Builder fileKey(String fileKey) {
            this.fileKey = fileKey;
            return this;
        }

        public final void setFileKey(String fileKey) {
            this.fileKey = fileKey;
        }

        public final String getReferenceRoleARN() {
            return referenceRoleARN;
        }

        @Override
        public final Builder referenceRoleARN(String referenceRoleARN) {
            this.referenceRoleARN = referenceRoleARN;
            return this;
        }

        public final void setReferenceRoleARN(String referenceRoleARN) {
            this.referenceRoleARN = referenceRoleARN;
        }

        @Override
        public S3ReferenceDataSourceDescription build() {
            return new S3ReferenceDataSourceDescription(this);
        }
    }
}
