/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.transform;

import java.time.Instant;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.kinesisanalytics.model.ApplicationDetail;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link ApplicationDetail} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class ApplicationDetailMarshaller {
    private static final MarshallingInfo<String> APPLICATIONNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ApplicationName").isBinary(false).build();

    private static final MarshallingInfo<String> APPLICATIONDESCRIPTION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ApplicationDescription").isBinary(false).build();

    private static final MarshallingInfo<String> APPLICATIONARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ApplicationARN").isBinary(false).build();

    private static final MarshallingInfo<String> APPLICATIONSTATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ApplicationStatus").isBinary(false).build();

    private static final MarshallingInfo<Instant> CREATETIMESTAMP_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreateTimestamp").isBinary(false).build();

    private static final MarshallingInfo<Instant> LASTUPDATETIMESTAMP_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastUpdateTimestamp").isBinary(false).build();

    private static final MarshallingInfo<List> INPUTDESCRIPTIONS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InputDescriptions").isBinary(false).build();

    private static final MarshallingInfo<List> OUTPUTDESCRIPTIONS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OutputDescriptions").isBinary(false).build();

    private static final MarshallingInfo<List> REFERENCEDATASOURCEDESCRIPTIONS_BINDING = MarshallingInfo
            .builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("ReferenceDataSourceDescriptions").isBinary(false).build();

    private static final MarshallingInfo<List> CLOUDWATCHLOGGINGOPTIONDESCRIPTIONS_BINDING = MarshallingInfo
            .builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("CloudWatchLoggingOptionDescriptions").isBinary(false).build();

    private static final MarshallingInfo<String> APPLICATIONCODE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ApplicationCode").isBinary(false).build();

    private static final MarshallingInfo<Long> APPLICATIONVERSIONID_BINDING = MarshallingInfo.builder(MarshallingType.LONG)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ApplicationVersionId").isBinary(false).build();

    private static final ApplicationDetailMarshaller INSTANCE = new ApplicationDetailMarshaller();

    private ApplicationDetailMarshaller() {
    }

    public static ApplicationDetailMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(ApplicationDetail applicationDetail, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(applicationDetail, "applicationDetail");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(applicationDetail.applicationName(), APPLICATIONNAME_BINDING);
            protocolMarshaller.marshall(applicationDetail.applicationDescription(), APPLICATIONDESCRIPTION_BINDING);
            protocolMarshaller.marshall(applicationDetail.applicationARN(), APPLICATIONARN_BINDING);
            protocolMarshaller.marshall(applicationDetail.applicationStatusString(), APPLICATIONSTATUS_BINDING);
            protocolMarshaller.marshall(applicationDetail.createTimestamp(), CREATETIMESTAMP_BINDING);
            protocolMarshaller.marshall(applicationDetail.lastUpdateTimestamp(), LASTUPDATETIMESTAMP_BINDING);
            protocolMarshaller.marshall(applicationDetail.inputDescriptions(), INPUTDESCRIPTIONS_BINDING);
            protocolMarshaller.marshall(applicationDetail.outputDescriptions(), OUTPUTDESCRIPTIONS_BINDING);
            protocolMarshaller.marshall(applicationDetail.referenceDataSourceDescriptions(),
                    REFERENCEDATASOURCEDESCRIPTIONS_BINDING);
            protocolMarshaller.marshall(applicationDetail.cloudWatchLoggingOptionDescriptions(),
                    CLOUDWATCHLOGGINGOPTIONDESCRIPTIONS_BINDING);
            protocolMarshaller.marshall(applicationDetail.applicationCode(), APPLICATIONCODE_BINDING);
            protocolMarshaller.marshall(applicationDetail.applicationVersionId(), APPLICATIONVERSIONID_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
