/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.transform;

import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.model.ReferenceDataSourceDescription;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link ReferenceDataSourceDescription} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class ReferenceDataSourceDescriptionMarshaller {
    private static final MarshallingInfo<String> REFERENCEID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReferenceId").isBinary(false).build();

    private static final MarshallingInfo<String> TABLENAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TableName").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> S3REFERENCEDATASOURCEDESCRIPTION_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("S3ReferenceDataSourceDescription").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> REFERENCESCHEMA_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("ReferenceSchema").isBinary(false).build();

    private static final ReferenceDataSourceDescriptionMarshaller INSTANCE = new ReferenceDataSourceDescriptionMarshaller();

    private ReferenceDataSourceDescriptionMarshaller() {
    }

    public static ReferenceDataSourceDescriptionMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(ReferenceDataSourceDescription referenceDataSourceDescription, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(referenceDataSourceDescription, "referenceDataSourceDescription");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(referenceDataSourceDescription.referenceId(), REFERENCEID_BINDING);
            protocolMarshaller.marshall(referenceDataSourceDescription.tableName(), TABLENAME_BINDING);
            protocolMarshaller.marshall(referenceDataSourceDescription.s3ReferenceDataSourceDescription(),
                    S3REFERENCEDATASOURCEDESCRIPTION_BINDING);
            protocolMarshaller.marshall(referenceDataSourceDescription.referenceSchema(), REFERENCESCHEMA_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
