/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.transform;

import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.kinesisanalytics.model.S3ReferenceDataSourceUpdate;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link S3ReferenceDataSourceUpdate} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class S3ReferenceDataSourceUpdateMarshaller {
    private static final MarshallingInfo<String> BUCKETARNUPDATE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BucketARNUpdate").isBinary(false).build();

    private static final MarshallingInfo<String> FILEKEYUPDATE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FileKeyUpdate").isBinary(false).build();

    private static final MarshallingInfo<String> REFERENCEROLEARNUPDATE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReferenceRoleARNUpdate").isBinary(false).build();

    private static final S3ReferenceDataSourceUpdateMarshaller INSTANCE = new S3ReferenceDataSourceUpdateMarshaller();

    private S3ReferenceDataSourceUpdateMarshaller() {
    }

    public static S3ReferenceDataSourceUpdateMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(S3ReferenceDataSourceUpdate s3ReferenceDataSourceUpdate, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(s3ReferenceDataSourceUpdate, "s3ReferenceDataSourceUpdate");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(s3ReferenceDataSourceUpdate.bucketARNUpdate(), BUCKETARNUPDATE_BINDING);
            protocolMarshaller.marshall(s3ReferenceDataSourceUpdate.fileKeyUpdate(), FILEKEYUPDATE_BINDING);
            protocolMarshaller.marshall(s3ReferenceDataSourceUpdate.referenceRoleARNUpdate(), REFERENCEROLEARNUPDATE_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
