/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.firehose.model.ElasticsearchDestinationDescription;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ElasticsearchDestinationDescriptionMarshaller {
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RoleARN").isBinary(false).build();
    private static final MarshallingInfo<String> DOMAINARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DomainARN").isBinary(false).build();
    private static final MarshallingInfo<String> INDEXNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IndexName").isBinary(false).build();
    private static final MarshallingInfo<String> TYPENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TypeName").isBinary(false).build();
    private static final MarshallingInfo<String> INDEXROTATIONPERIOD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IndexRotationPeriod").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> BUFFERINGHINTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BufferingHints").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> RETRYOPTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RetryOptions").isBinary(false).build();
    private static final MarshallingInfo<String> S3BACKUPMODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3BackupMode").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> S3DESTINATIONDESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3DestinationDescription").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> PROCESSINGCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProcessingConfiguration").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> CLOUDWATCHLOGGINGOPTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CloudWatchLoggingOptions").isBinary(false).build();
    private static final ElasticsearchDestinationDescriptionMarshaller INSTANCE = new ElasticsearchDestinationDescriptionMarshaller();

    private ElasticsearchDestinationDescriptionMarshaller() {
    }

    public static ElasticsearchDestinationDescriptionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ElasticsearchDestinationDescription elasticsearchDestinationDescription, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)elasticsearchDestinationDescription, (String)"elasticsearchDestinationDescription");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)elasticsearchDestinationDescription.roleARN(), ROLEARN_BINDING);
            protocolMarshaller.marshall((Object)elasticsearchDestinationDescription.domainARN(), DOMAINARN_BINDING);
            protocolMarshaller.marshall((Object)elasticsearchDestinationDescription.indexName(), INDEXNAME_BINDING);
            protocolMarshaller.marshall((Object)elasticsearchDestinationDescription.typeName(), TYPENAME_BINDING);
            protocolMarshaller.marshall((Object)elasticsearchDestinationDescription.indexRotationPeriodString(), INDEXROTATIONPERIOD_BINDING);
            protocolMarshaller.marshall((Object)elasticsearchDestinationDescription.bufferingHints(), BUFFERINGHINTS_BINDING);
            protocolMarshaller.marshall((Object)elasticsearchDestinationDescription.retryOptions(), RETRYOPTIONS_BINDING);
            protocolMarshaller.marshall((Object)elasticsearchDestinationDescription.s3BackupModeString(), S3BACKUPMODE_BINDING);
            protocolMarshaller.marshall((Object)elasticsearchDestinationDescription.s3DestinationDescription(), S3DESTINATIONDESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)elasticsearchDestinationDescription.processingConfiguration(), PROCESSINGCONFIGURATION_BINDING);
            protocolMarshaller.marshall((Object)elasticsearchDestinationDescription.cloudWatchLoggingOptions(), CLOUDWATCHLOGGINGOPTIONS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

