/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.firehose.model.PutRecordBatchRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class PutRecordBatchRequestModelMarshaller {
    private static final MarshallingInfo<String> DELIVERYSTREAMNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeliveryStreamName").isBinary(false).build();
    private static final MarshallingInfo<List> RECORDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Records").isBinary(false).build();
    private static final PutRecordBatchRequestModelMarshaller INSTANCE = new PutRecordBatchRequestModelMarshaller();

    private PutRecordBatchRequestModelMarshaller() {
    }

    public static PutRecordBatchRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(PutRecordBatchRequest putRecordBatchRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)putRecordBatchRequest), (String)"putRecordBatchRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)putRecordBatchRequest.deliveryStreamName(), DELIVERYSTREAMNAME_BINDING);
            protocolMarshaller.marshall(putRecordBatchRequest.records(), RECORDS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

