/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.firehose.model.S3DestinationConfiguration;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class S3DestinationConfigurationMarshaller {
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RoleARN").isBinary(false).build();
    private static final MarshallingInfo<String> BUCKETARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BucketARN").isBinary(false).build();
    private static final MarshallingInfo<String> PREFIX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Prefix").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> BUFFERINGHINTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BufferingHints").isBinary(false).build();
    private static final MarshallingInfo<String> COMPRESSIONFORMAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CompressionFormat").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> ENCRYPTIONCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EncryptionConfiguration").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> CLOUDWATCHLOGGINGOPTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CloudWatchLoggingOptions").isBinary(false).build();
    private static final S3DestinationConfigurationMarshaller INSTANCE = new S3DestinationConfigurationMarshaller();

    private S3DestinationConfigurationMarshaller() {
    }

    public static S3DestinationConfigurationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(S3DestinationConfiguration s3DestinationConfiguration, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)s3DestinationConfiguration, (String)"s3DestinationConfiguration");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)s3DestinationConfiguration.roleARN(), ROLEARN_BINDING);
            protocolMarshaller.marshall((Object)s3DestinationConfiguration.bucketARN(), BUCKETARN_BINDING);
            protocolMarshaller.marshall((Object)s3DestinationConfiguration.prefix(), PREFIX_BINDING);
            protocolMarshaller.marshall((Object)s3DestinationConfiguration.bufferingHints(), BUFFERINGHINTS_BINDING);
            protocolMarshaller.marshall((Object)s3DestinationConfiguration.compressionFormatString(), COMPRESSIONFORMAT_BINDING);
            protocolMarshaller.marshall((Object)s3DestinationConfiguration.encryptionConfiguration(), ENCRYPTIONCONFIGURATION_BINDING);
            protocolMarshaller.marshall((Object)s3DestinationConfiguration.cloudWatchLoggingOptions(), CLOUDWATCHLOGGINGOPTIONS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

