/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.firehose.model.UpdateDestinationRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class UpdateDestinationRequestModelMarshaller {
    private static final MarshallingInfo<String> DELIVERYSTREAMNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeliveryStreamName").isBinary(false).build();
    private static final MarshallingInfo<String> CURRENTDELIVERYSTREAMVERSIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CurrentDeliveryStreamVersionId").isBinary(false).build();
    private static final MarshallingInfo<String> DESTINATIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DestinationId").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> S3DESTINATIONUPDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3DestinationUpdate").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> EXTENDEDS3DESTINATIONUPDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExtendedS3DestinationUpdate").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> REDSHIFTDESTINATIONUPDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RedshiftDestinationUpdate").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> ELASTICSEARCHDESTINATIONUPDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ElasticsearchDestinationUpdate").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> SPLUNKDESTINATIONUPDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SplunkDestinationUpdate").isBinary(false).build();
    private static final UpdateDestinationRequestModelMarshaller INSTANCE = new UpdateDestinationRequestModelMarshaller();

    private UpdateDestinationRequestModelMarshaller() {
    }

    public static UpdateDestinationRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(UpdateDestinationRequest updateDestinationRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)updateDestinationRequest), (String)"updateDestinationRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)updateDestinationRequest.deliveryStreamName(), DELIVERYSTREAMNAME_BINDING);
            protocolMarshaller.marshall((Object)updateDestinationRequest.currentDeliveryStreamVersionId(), CURRENTDELIVERYSTREAMVERSIONID_BINDING);
            protocolMarshaller.marshall((Object)updateDestinationRequest.destinationId(), DESTINATIONID_BINDING);
            protocolMarshaller.marshall((Object)updateDestinationRequest.s3DestinationUpdate(), S3DESTINATIONUPDATE_BINDING);
            protocolMarshaller.marshall((Object)updateDestinationRequest.extendedS3DestinationUpdate(), EXTENDEDS3DESTINATIONUPDATE_BINDING);
            protocolMarshaller.marshall((Object)updateDestinationRequest.redshiftDestinationUpdate(), REDSHIFTDESTINATIONUPDATE_BINDING);
            protocolMarshaller.marshall((Object)updateDestinationRequest.elasticsearchDestinationUpdate(), ELASTICSEARCHDESTINATIONUPDATE_BINDING);
            protocolMarshaller.marshall((Object)updateDestinationRequest.splunkDestinationUpdate(), SPLUNKDESTINATIONUPDATE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

