/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.kinesis.model.KinesisResponse;
import software.amazon.awssdk.services.kinesis.model.StreamNameListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListStreamsResponse
extends KinesisResponse
implements ToCopyableBuilder<Builder, ListStreamsResponse> {
    private final List<String> streamNames;
    private final Boolean hasMoreStreams;

    private ListStreamsResponse(BuilderImpl builder) {
        super(builder);
        this.streamNames = builder.streamNames;
        this.hasMoreStreams = builder.hasMoreStreams;
    }

    public List<String> streamNames() {
        return this.streamNames;
    }

    public Boolean hasMoreStreams() {
        return this.hasMoreStreams;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.streamNames());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMoreStreams());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStreamsResponse)) {
            return false;
        }
        ListStreamsResponse other = (ListStreamsResponse)((Object)obj);
        return Objects.equals(this.streamNames(), other.streamNames()) && Objects.equals(this.hasMoreStreams(), other.hasMoreStreams());
    }

    public String toString() {
        return ToString.builder((String)"ListStreamsResponse").add("StreamNames", this.streamNames()).add("HasMoreStreams", (Object)this.hasMoreStreams()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StreamNames": {
                return Optional.of(clazz.cast(this.streamNames()));
            }
            case "HasMoreStreams": {
                return Optional.of(clazz.cast(this.hasMoreStreams()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends KinesisResponse.BuilderImpl
    implements Builder {
        private List<String> streamNames;
        private Boolean hasMoreStreams;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStreamsResponse model) {
            this.streamNames(model.streamNames);
            this.hasMoreStreams(model.hasMoreStreams);
        }

        public final Collection<String> getStreamNames() {
            return this.streamNames;
        }

        @Override
        public final Builder streamNames(Collection<String> streamNames) {
            this.streamNames = StreamNameListCopier.copy(streamNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder streamNames(String ... streamNames) {
            this.streamNames(Arrays.asList(streamNames));
            return this;
        }

        public final void setStreamNames(Collection<String> streamNames) {
            this.streamNames = StreamNameListCopier.copy(streamNames);
        }

        public final Boolean getHasMoreStreams() {
            return this.hasMoreStreams;
        }

        @Override
        public final Builder hasMoreStreams(Boolean hasMoreStreams) {
            this.hasMoreStreams = hasMoreStreams;
            return this;
        }

        public final void setHasMoreStreams(Boolean hasMoreStreams) {
            this.hasMoreStreams = hasMoreStreams;
        }

        @Override
        public ListStreamsResponse build() {
            return new ListStreamsResponse(this);
        }
    }

    public static interface Builder
    extends KinesisResponse.Builder,
    CopyableBuilder<Builder, ListStreamsResponse> {
        public Builder streamNames(Collection<String> var1);

        public Builder streamNames(String ... var1);

        public Builder hasMoreStreams(Boolean var1);
    }
}

