/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.kinesis.model.EncryptionType;
import software.amazon.awssdk.services.kinesis.model.KinesisRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class StartStreamEncryptionRequest
extends KinesisRequest
implements ToCopyableBuilder<Builder, StartStreamEncryptionRequest> {
    private final String streamName;
    private final String encryptionType;
    private final String keyId;

    private StartStreamEncryptionRequest(BuilderImpl builder) {
        super(builder);
        this.streamName = builder.streamName;
        this.encryptionType = builder.encryptionType;
        this.keyId = builder.keyId;
    }

    public String streamName() {
        return this.streamName;
    }

    public EncryptionType encryptionType() {
        return EncryptionType.fromValue(this.encryptionType);
    }

    public String encryptionTypeString() {
        return this.encryptionType;
    }

    public String keyId() {
        return this.keyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.streamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartStreamEncryptionRequest)) {
            return false;
        }
        StartStreamEncryptionRequest other = (StartStreamEncryptionRequest)((Object)obj);
        return Objects.equals(this.streamName(), other.streamName()) && Objects.equals(this.encryptionTypeString(), other.encryptionTypeString()) && Objects.equals(this.keyId(), other.keyId());
    }

    public String toString() {
        return ToString.builder((String)"StartStreamEncryptionRequest").add("StreamName", (Object)this.streamName()).add("EncryptionType", (Object)this.encryptionTypeString()).add("KeyId", (Object)this.keyId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StreamName": {
                return Optional.of(clazz.cast(this.streamName()));
            }
            case "EncryptionType": {
                return Optional.of(clazz.cast(this.encryptionTypeString()));
            }
            case "KeyId": {
                return Optional.of(clazz.cast(this.keyId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends KinesisRequest.BuilderImpl
    implements Builder {
        private String streamName;
        private String encryptionType;
        private String keyId;

        private BuilderImpl() {
        }

        private BuilderImpl(StartStreamEncryptionRequest model) {
            this.streamName(model.streamName);
            this.encryptionType(model.encryptionType);
            this.keyId(model.keyId);
        }

        public final String getStreamName() {
            return this.streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        public final String getEncryptionType() {
            return this.encryptionType;
        }

        @Override
        public final Builder encryptionType(String encryptionType) {
            this.encryptionType = encryptionType;
            return this;
        }

        @Override
        public final Builder encryptionType(EncryptionType encryptionType) {
            this.encryptionType(encryptionType.toString());
            return this;
        }

        public final void setEncryptionType(String encryptionType) {
            this.encryptionType = encryptionType;
        }

        public final String getKeyId() {
            return this.keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public StartStreamEncryptionRequest build() {
            return new StartStreamEncryptionRequest(this);
        }
    }

    public static interface Builder
    extends KinesisRequest.Builder,
    CopyableBuilder<Builder, StartStreamEncryptionRequest> {
        public Builder streamName(String var1);

        public Builder encryptionType(String var1);

        public Builder encryptionType(EncryptionType var1);

        public Builder keyId(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

