/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.transform;

import java.nio.ByteBuffer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.kinesis.model.PutRecordsRequestEntry;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class PutRecordsRequestEntryMarshaller {
    private static final MarshallingInfo<ByteBuffer> DATA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BYTE_BUFFER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Data").isBinary(false).build();
    private static final MarshallingInfo<String> EXPLICITHASHKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExplicitHashKey").isBinary(false).build();
    private static final MarshallingInfo<String> PARTITIONKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PartitionKey").isBinary(false).build();
    private static final PutRecordsRequestEntryMarshaller INSTANCE = new PutRecordsRequestEntryMarshaller();

    private PutRecordsRequestEntryMarshaller() {
    }

    public static PutRecordsRequestEntryMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(PutRecordsRequestEntry putRecordsRequestEntry, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)putRecordsRequestEntry, (String)"putRecordsRequestEntry");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)putRecordsRequestEntry.data(), DATA_BINDING);
            protocolMarshaller.marshall((Object)putRecordsRequestEntry.explicitHashKey(), EXPLICITHASHKEY_BINDING);
            protocolMarshaller.marshall((Object)putRecordsRequestEntry.partitionKey(), PARTITIONKEY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

