/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.model.ApplicationStatus;
import software.amazon.awssdk.services.kinesisanalytics.transform.ApplicationSummaryMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ApplicationSummary
implements StructuredPojo,
ToCopyableBuilder<Builder, ApplicationSummary> {
    private final String applicationName;
    private final String applicationARN;
    private final String applicationStatus;

    private ApplicationSummary(BuilderImpl builder) {
        this.applicationName = builder.applicationName;
        this.applicationARN = builder.applicationARN;
        this.applicationStatus = builder.applicationStatus;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public String applicationARN() {
        return this.applicationARN;
    }

    public ApplicationStatus applicationStatus() {
        return ApplicationStatus.fromValue(this.applicationStatus);
    }

    public String applicationStatusString() {
        return this.applicationStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationStatusString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationSummary)) {
            return false;
        }
        ApplicationSummary other = (ApplicationSummary)obj;
        return Objects.equals(this.applicationName(), other.applicationName()) && Objects.equals(this.applicationARN(), other.applicationARN()) && Objects.equals(this.applicationStatusString(), other.applicationStatusString());
    }

    public String toString() {
        return ToString.builder((String)"ApplicationSummary").add("ApplicationName", (Object)this.applicationName()).add("ApplicationARN", (Object)this.applicationARN()).add("ApplicationStatus", (Object)this.applicationStatusString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationName": {
                return Optional.of(clazz.cast(this.applicationName()));
            }
            case "ApplicationARN": {
                return Optional.of(clazz.cast(this.applicationARN()));
            }
            case "ApplicationStatus": {
                return Optional.of(clazz.cast(this.applicationStatusString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ApplicationSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationName;
        private String applicationARN;
        private String applicationStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationSummary model) {
            this.applicationName(model.applicationName);
            this.applicationARN(model.applicationARN);
            this.applicationStatus(model.applicationStatus);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final String getApplicationARN() {
            return this.applicationARN;
        }

        @Override
        public final Builder applicationARN(String applicationARN) {
            this.applicationARN = applicationARN;
            return this;
        }

        public final void setApplicationARN(String applicationARN) {
            this.applicationARN = applicationARN;
        }

        public final String getApplicationStatus() {
            return this.applicationStatus;
        }

        @Override
        public final Builder applicationStatus(String applicationStatus) {
            this.applicationStatus = applicationStatus;
            return this;
        }

        @Override
        public final Builder applicationStatus(ApplicationStatus applicationStatus) {
            this.applicationStatus(applicationStatus.toString());
            return this;
        }

        public final void setApplicationStatus(String applicationStatus) {
            this.applicationStatus = applicationStatus;
        }

        public ApplicationSummary build() {
            return new ApplicationSummary(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ApplicationSummary> {
        public Builder applicationName(String var1);

        public Builder applicationARN(String var1);

        public Builder applicationStatus(String var1);

        public Builder applicationStatus(ApplicationStatus var1);
    }
}

