/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.kinesisanalytics.model.CloudWatchLoggingOption;
import software.amazon.awssdk.services.kinesisanalytics.model.CloudWatchLoggingOptionsCopier;
import software.amazon.awssdk.services.kinesisanalytics.model.Input;
import software.amazon.awssdk.services.kinesisanalytics.model.InputsCopier;
import software.amazon.awssdk.services.kinesisanalytics.model.KinesisAnalyticsRequest;
import software.amazon.awssdk.services.kinesisanalytics.model.Output;
import software.amazon.awssdk.services.kinesisanalytics.model.OutputsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateApplicationRequest
extends KinesisAnalyticsRequest
implements ToCopyableBuilder<Builder, CreateApplicationRequest> {
    private final String applicationName;
    private final String applicationDescription;
    private final List<Input> inputs;
    private final List<Output> outputs;
    private final List<CloudWatchLoggingOption> cloudWatchLoggingOptions;
    private final String applicationCode;

    private CreateApplicationRequest(BuilderImpl builder) {
        super(builder);
        this.applicationName = builder.applicationName;
        this.applicationDescription = builder.applicationDescription;
        this.inputs = builder.inputs;
        this.outputs = builder.outputs;
        this.cloudWatchLoggingOptions = builder.cloudWatchLoggingOptions;
        this.applicationCode = builder.applicationCode;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public String applicationDescription() {
        return this.applicationDescription;
    }

    public List<Input> inputs() {
        return this.inputs;
    }

    public List<Output> outputs() {
        return this.outputs;
    }

    public List<CloudWatchLoggingOption> cloudWatchLoggingOptions() {
        return this.cloudWatchLoggingOptions;
    }

    public String applicationCode() {
        return this.applicationCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputs());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputs());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchLoggingOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateApplicationRequest)) {
            return false;
        }
        CreateApplicationRequest other = (CreateApplicationRequest)((Object)obj);
        return Objects.equals(this.applicationName(), other.applicationName()) && Objects.equals(this.applicationDescription(), other.applicationDescription()) && Objects.equals(this.inputs(), other.inputs()) && Objects.equals(this.outputs(), other.outputs()) && Objects.equals(this.cloudWatchLoggingOptions(), other.cloudWatchLoggingOptions()) && Objects.equals(this.applicationCode(), other.applicationCode());
    }

    public String toString() {
        return ToString.builder((String)"CreateApplicationRequest").add("ApplicationName", (Object)this.applicationName()).add("ApplicationDescription", (Object)this.applicationDescription()).add("Inputs", this.inputs()).add("Outputs", this.outputs()).add("CloudWatchLoggingOptions", this.cloudWatchLoggingOptions()).add("ApplicationCode", (Object)this.applicationCode()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationName": {
                return Optional.of(clazz.cast(this.applicationName()));
            }
            case "ApplicationDescription": {
                return Optional.of(clazz.cast(this.applicationDescription()));
            }
            case "Inputs": {
                return Optional.of(clazz.cast(this.inputs()));
            }
            case "Outputs": {
                return Optional.of(clazz.cast(this.outputs()));
            }
            case "CloudWatchLoggingOptions": {
                return Optional.of(clazz.cast(this.cloudWatchLoggingOptions()));
            }
            case "ApplicationCode": {
                return Optional.of(clazz.cast(this.applicationCode()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends KinesisAnalyticsRequest.BuilderImpl
    implements Builder {
        private String applicationName;
        private String applicationDescription;
        private List<Input> inputs;
        private List<Output> outputs;
        private List<CloudWatchLoggingOption> cloudWatchLoggingOptions;
        private String applicationCode;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateApplicationRequest model) {
            this.applicationName(model.applicationName);
            this.applicationDescription(model.applicationDescription);
            this.inputs(model.inputs);
            this.outputs(model.outputs);
            this.cloudWatchLoggingOptions(model.cloudWatchLoggingOptions);
            this.applicationCode(model.applicationCode);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final String getApplicationDescription() {
            return this.applicationDescription;
        }

        @Override
        public final Builder applicationDescription(String applicationDescription) {
            this.applicationDescription = applicationDescription;
            return this;
        }

        public final void setApplicationDescription(String applicationDescription) {
            this.applicationDescription = applicationDescription;
        }

        public final Collection<Input.Builder> getInputs() {
            return this.inputs != null ? (Collection)this.inputs.stream().map(Input::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder inputs(Collection<Input> inputs) {
            this.inputs = InputsCopier.copy(inputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(Input ... inputs) {
            this.inputs(Arrays.asList(inputs));
            return this;
        }

        public final void setInputs(Collection<Input.BuilderImpl> inputs) {
            this.inputs = InputsCopier.copyFromBuilder(inputs);
        }

        public final Collection<Output.Builder> getOutputs() {
            return this.outputs != null ? (Collection)this.outputs.stream().map(Output::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder outputs(Collection<Output> outputs) {
            this.outputs = OutputsCopier.copy(outputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(Output ... outputs) {
            this.outputs(Arrays.asList(outputs));
            return this;
        }

        public final void setOutputs(Collection<Output.BuilderImpl> outputs) {
            this.outputs = OutputsCopier.copyFromBuilder(outputs);
        }

        public final Collection<CloudWatchLoggingOption.Builder> getCloudWatchLoggingOptions() {
            return this.cloudWatchLoggingOptions != null ? (Collection)this.cloudWatchLoggingOptions.stream().map(CloudWatchLoggingOption::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder cloudWatchLoggingOptions(Collection<CloudWatchLoggingOption> cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = CloudWatchLoggingOptionsCopier.copy(cloudWatchLoggingOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cloudWatchLoggingOptions(CloudWatchLoggingOption ... cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions(Arrays.asList(cloudWatchLoggingOptions));
            return this;
        }

        public final void setCloudWatchLoggingOptions(Collection<CloudWatchLoggingOption.BuilderImpl> cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = CloudWatchLoggingOptionsCopier.copyFromBuilder(cloudWatchLoggingOptions);
        }

        public final String getApplicationCode() {
            return this.applicationCode;
        }

        @Override
        public final Builder applicationCode(String applicationCode) {
            this.applicationCode = applicationCode;
            return this;
        }

        public final void setApplicationCode(String applicationCode) {
            this.applicationCode = applicationCode;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateApplicationRequest build() {
            return new CreateApplicationRequest(this);
        }
    }

    public static interface Builder
    extends KinesisAnalyticsRequest.Builder,
    CopyableBuilder<Builder, CreateApplicationRequest> {
        public Builder applicationName(String var1);

        public Builder applicationDescription(String var1);

        public Builder inputs(Collection<Input> var1);

        public Builder inputs(Input ... var1);

        public Builder outputs(Collection<Output> var1);

        public Builder outputs(Output ... var1);

        public Builder cloudWatchLoggingOptions(Collection<CloudWatchLoggingOption> var1);

        public Builder cloudWatchLoggingOptions(CloudWatchLoggingOption ... var1);

        public Builder applicationCode(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

