/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesis.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListStreamConsumersResponse extends KinesisResponse implements
        ToCopyableBuilder<ListStreamConsumersResponse.Builder, ListStreamConsumersResponse> {
    private final List<Consumer> consumers;

    private final String nextToken;

    private ListStreamConsumersResponse(BuilderImpl builder) {
        super(builder);
        this.consumers = builder.consumers;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * An array of JSON objects. Each object represents one registered consumer.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of JSON objects. Each object represents one registered consumer.
     */
    public List<Consumer> consumers() {
        return consumers;
    }

    /**
     * <p>
     * When the number of consumers that are registered with the data stream is greater than the default value for the
     * <code>MaxResults</code> parameter, or if you explicitly specify a value for <code>MaxResults</code> that is less
     * than the number of registered consumers, the response includes a pagination token named <code>NextToken</code>.
     * You can specify this <code>NextToken</code> value in a subsequent call to <code>ListStreamConsumers</code> to
     * list the next set of registered consumers. For more information about the use of this pagination token when
     * calling the <code>ListStreamConsumers</code> operation, see <a>ListStreamConsumersInput$NextToken</a>.
     * </p>
     * <important>
     * <p>
     * Tokens expire after 300 seconds. When you obtain a value for <code>NextToken</code> in the response to a call to
     * <code>ListStreamConsumers</code>, you have 300 seconds to use that value. If you specify an expired token in a
     * call to <code>ListStreamConsumers</code>, you get <code>ExpiredNextTokenException</code>.
     * </p>
     * </important>
     * 
     * @return When the number of consumers that are registered with the data stream is greater than the default value
     *         for the <code>MaxResults</code> parameter, or if you explicitly specify a value for
     *         <code>MaxResults</code> that is less than the number of registered consumers, the response includes a
     *         pagination token named <code>NextToken</code>. You can specify this <code>NextToken</code> value in a
     *         subsequent call to <code>ListStreamConsumers</code> to list the next set of registered consumers. For
     *         more information about the use of this pagination token when calling the <code>ListStreamConsumers</code>
     *         operation, see <a>ListStreamConsumersInput$NextToken</a>.</p> <important>
     *         <p>
     *         Tokens expire after 300 seconds. When you obtain a value for <code>NextToken</code> in the response to a
     *         call to <code>ListStreamConsumers</code>, you have 300 seconds to use that value. If you specify an
     *         expired token in a call to <code>ListStreamConsumers</code>, you get
     *         <code>ExpiredNextTokenException</code>.
     *         </p>
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(consumers());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStreamConsumersResponse)) {
            return false;
        }
        ListStreamConsumersResponse other = (ListStreamConsumersResponse) obj;
        return Objects.equals(consumers(), other.consumers()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("ListStreamConsumersResponse").add("Consumers", consumers()).add("NextToken", nextToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Consumers":
            return Optional.ofNullable(clazz.cast(consumers()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends KinesisResponse.Builder, CopyableBuilder<Builder, ListStreamConsumersResponse> {
        /**
         * <p>
         * An array of JSON objects. Each object represents one registered consumer.
         * </p>
         * 
         * @param consumers
         *        An array of JSON objects. Each object represents one registered consumer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consumers(Collection<Consumer> consumers);

        /**
         * <p>
         * An array of JSON objects. Each object represents one registered consumer.
         * </p>
         * 
         * @param consumers
         *        An array of JSON objects. Each object represents one registered consumer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consumers(Consumer... consumers);

        /**
         * <p>
         * An array of JSON objects. Each object represents one registered consumer.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Consumer>.Builder} avoiding the need to
         * create one manually via {@link List<Consumer>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Consumer>.Builder#build()} is called immediately and its
         * result is passed to {@link #consumers(List<Consumer>)}.
         * 
         * @param consumers
         *        a consumer that will call methods on {@link List<Consumer>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #consumers(List<Consumer>)
         */
        Builder consumers(java.util.function.Consumer<Consumer.Builder>... consumers);

        /**
         * <p>
         * When the number of consumers that are registered with the data stream is greater than the default value for
         * the <code>MaxResults</code> parameter, or if you explicitly specify a value for <code>MaxResults</code> that
         * is less than the number of registered consumers, the response includes a pagination token named
         * <code>NextToken</code>. You can specify this <code>NextToken</code> value in a subsequent call to
         * <code>ListStreamConsumers</code> to list the next set of registered consumers. For more information about the
         * use of this pagination token when calling the <code>ListStreamConsumers</code> operation, see
         * <a>ListStreamConsumersInput$NextToken</a>.
         * </p>
         * <important>
         * <p>
         * Tokens expire after 300 seconds. When you obtain a value for <code>NextToken</code> in the response to a call
         * to <code>ListStreamConsumers</code>, you have 300 seconds to use that value. If you specify an expired token
         * in a call to <code>ListStreamConsumers</code>, you get <code>ExpiredNextTokenException</code>.
         * </p>
         * </important>
         * 
         * @param nextToken
         *        When the number of consumers that are registered with the data stream is greater than the default
         *        value for the <code>MaxResults</code> parameter, or if you explicitly specify a value for
         *        <code>MaxResults</code> that is less than the number of registered consumers, the response includes a
         *        pagination token named <code>NextToken</code>. You can specify this <code>NextToken</code> value in a
         *        subsequent call to <code>ListStreamConsumers</code> to list the next set of registered consumers. For
         *        more information about the use of this pagination token when calling the
         *        <code>ListStreamConsumers</code> operation, see <a>ListStreamConsumersInput$NextToken</a>.</p>
         *        <important>
         *        <p>
         *        Tokens expire after 300 seconds. When you obtain a value for <code>NextToken</code> in the response to
         *        a call to <code>ListStreamConsumers</code>, you have 300 seconds to use that value. If you specify an
         *        expired token in a call to <code>ListStreamConsumers</code>, you get
         *        <code>ExpiredNextTokenException</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends KinesisResponse.BuilderImpl implements Builder {
        private List<Consumer> consumers = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStreamConsumersResponse model) {
            super(model);
            consumers(model.consumers);
            nextToken(model.nextToken);
        }

        public final Collection<Consumer.Builder> getConsumers() {
            return consumers != null ? consumers.stream().map(Consumer::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder consumers(Collection<Consumer> consumers) {
            this.consumers = ConsumerListCopier.copy(consumers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder consumers(Consumer... consumers) {
            consumers(Arrays.asList(consumers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder consumers(java.util.function.Consumer<Consumer.Builder>... consumers) {
            consumers(Stream.of(consumers).map(c -> Consumer.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setConsumers(Collection<Consumer.BuilderImpl> consumers) {
            this.consumers = ConsumerListCopier.copyFromBuilder(consumers);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListStreamConsumersResponse build() {
            return new ListStreamConsumersResponse(this);
        }
    }
}
