/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesis.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.kinesis.model.Consumer;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link Consumer} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class ConsumerMarshaller {
    private static final MarshallingInfo<String> CONSUMERNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConsumerName").isBinary(false).build();

    private static final MarshallingInfo<String> CONSUMERARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConsumerARN").isBinary(false).build();

    private static final MarshallingInfo<String> CONSUMERSTATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConsumerStatus").isBinary(false).build();

    private static final MarshallingInfo<Instant> CONSUMERCREATIONTIMESTAMP_BINDING = MarshallingInfo
            .builder(MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("ConsumerCreationTimestamp").isBinary(false).build();

    private static final ConsumerMarshaller INSTANCE = new ConsumerMarshaller();

    private ConsumerMarshaller() {
    }

    public static ConsumerMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(Consumer consumer, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(consumer, "consumer");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(consumer.consumerName(), CONSUMERNAME_BINDING);
            protocolMarshaller.marshall(consumer.consumerARN(), CONSUMERARN_BINDING);
            protocolMarshaller.marshall(consumer.consumerStatusAsString(), CONSUMERSTATUS_BINDING);
            protocolMarshaller.marshall(consumer.consumerCreationTimestamp(), CONSUMERCREATIONTIMESTAMP_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
