/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.kinesis.model.SubscribeToShardEvent;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SubscribeToShardEventMarshaller {
    private static final MarshallingInfo<List> RECORDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Records").isBinary(false).build();
    private static final MarshallingInfo<String> CONTINUATIONSEQUENCENUMBER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ContinuationSequenceNumber").isBinary(false).build();
    private static final MarshallingInfo<Long> MILLISBEHINDLATEST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MillisBehindLatest").isBinary(false).build();
    private static final SubscribeToShardEventMarshaller INSTANCE = new SubscribeToShardEventMarshaller();

    private SubscribeToShardEventMarshaller() {
    }

    public static SubscribeToShardEventMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SubscribeToShardEvent subscribeToShardEvent, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)subscribeToShardEvent, (String)"subscribeToShardEvent");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(subscribeToShardEvent.records(), RECORDS_BINDING);
            protocolMarshaller.marshall((Object)subscribeToShardEvent.continuationSequenceNumber(), CONTINUATIONSEQUENCENUMBER_BINDING);
            protocolMarshaller.marshall((Object)subscribeToShardEvent.millisBehindLatest(), MILLISBEHINDLATEST_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

