/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesis.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.kinesis.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * StreamDescriptionSummary JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class StreamDescriptionSummaryUnmarshaller implements Unmarshaller<StreamDescriptionSummary, JsonUnmarshallerContext> {

    public StreamDescriptionSummary unmarshall(JsonUnmarshallerContext context) throws Exception {
        StreamDescriptionSummary.Builder streamDescriptionSummaryBuilder = StreamDescriptionSummary.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("StreamName", targetDepth)) {
                    context.nextToken();
                    streamDescriptionSummaryBuilder.streamName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("StreamARN", targetDepth)) {
                    context.nextToken();
                    streamDescriptionSummaryBuilder.streamARN(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("StreamStatus", targetDepth)) {
                    context.nextToken();
                    streamDescriptionSummaryBuilder.streamStatus(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("RetentionPeriodHours", targetDepth)) {
                    context.nextToken();
                    streamDescriptionSummaryBuilder.retentionPeriodHours(context.getUnmarshaller(Integer.class).unmarshall(
                            context));
                }
                if (context.testExpression("StreamCreationTimestamp", targetDepth)) {
                    context.nextToken();
                    streamDescriptionSummaryBuilder.streamCreationTimestamp(context.getUnmarshaller(java.time.Instant.class)
                            .unmarshall(context));
                }
                if (context.testExpression("EnhancedMonitoring", targetDepth)) {
                    context.nextToken();
                    streamDescriptionSummaryBuilder.enhancedMonitoring(new ListUnmarshaller<EnhancedMetrics>(
                            EnhancedMetricsUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("EncryptionType", targetDepth)) {
                    context.nextToken();
                    streamDescriptionSummaryBuilder.encryptionType(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("KeyId", targetDepth)) {
                    context.nextToken();
                    streamDescriptionSummaryBuilder.keyId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("OpenShardCount", targetDepth)) {
                    context.nextToken();
                    streamDescriptionSummaryBuilder.openShardCount(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("ConsumerCount", targetDepth)) {
                    context.nextToken();
                    streamDescriptionSummaryBuilder.consumerCount(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return streamDescriptionSummaryBuilder.build();
    }

    private static final StreamDescriptionSummaryUnmarshaller INSTANCE = new StreamDescriptionSummaryUnmarshaller();

    public static StreamDescriptionSummaryUnmarshaller getInstance() {
        return INSTANCE;
    }
}
