/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesis.model.SubscribeToShardRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SubscribeToShardRequestModelMarshaller {
    private static final MarshallingInfo<String> CONSUMERARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConsumerARN").isBinary(false).build();
    private static final MarshallingInfo<String> SHARDID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ShardId").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> STARTINGPOSITION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartingPosition").isBinary(false).build();
    private static final SubscribeToShardRequestModelMarshaller INSTANCE = new SubscribeToShardRequestModelMarshaller();

    private SubscribeToShardRequestModelMarshaller() {
    }

    public static SubscribeToShardRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SubscribeToShardRequest subscribeToShardRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)subscribeToShardRequest), (String)"subscribeToShardRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)subscribeToShardRequest.consumerARN(), CONSUMERARN_BINDING);
            protocolMarshaller.marshall((Object)subscribeToShardRequest.shardId(), SHARDID_BINDING);
            protocolMarshaller.marshall((Object)subscribeToShardRequest.startingPosition(), STARTINGPOSITION_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

