/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesis.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input for <code>CreateStream</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateStreamRequest extends KinesisRequest implements
        ToCopyableBuilder<CreateStreamRequest.Builder, CreateStreamRequest> {
    private final String streamName;

    private final Integer shardCount;

    private CreateStreamRequest(BuilderImpl builder) {
        super(builder);
        this.streamName = builder.streamName;
        this.shardCount = builder.shardCount;
    }

    /**
     * <p>
     * A name to identify the stream. The stream name is scoped to the AWS account used by the application that creates
     * the stream. It is also scoped by AWS Region. That is, two streams in two different AWS accounts can have the same
     * name. Two streams in the same AWS account but in two different Regions can also have the same name.
     * </p>
     * 
     * @return A name to identify the stream. The stream name is scoped to the AWS account used by the application that
     *         creates the stream. It is also scoped by AWS Region. That is, two streams in two different AWS accounts
     *         can have the same name. Two streams in the same AWS account but in two different Regions can also have
     *         the same name.
     */
    public String streamName() {
        return streamName;
    }

    /**
     * <p>
     * The number of shards that the stream will use. The throughput of the stream is a function of the number of
     * shards; more shards are required for greater provisioned throughput.
     * </p>
     * <p>
     * DefaultShardLimit;
     * </p>
     * 
     * @return The number of shards that the stream will use. The throughput of the stream is a function of the number
     *         of shards; more shards are required for greater provisioned throughput.</p>
     *         <p>
     *         DefaultShardLimit;
     */
    public Integer shardCount() {
        return shardCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(streamName());
        hashCode = 31 * hashCode + Objects.hashCode(shardCount());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStreamRequest)) {
            return false;
        }
        CreateStreamRequest other = (CreateStreamRequest) obj;
        return Objects.equals(streamName(), other.streamName()) && Objects.equals(shardCount(), other.shardCount());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateStreamRequest").add("StreamName", streamName()).add("ShardCount", shardCount()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StreamName":
            return Optional.ofNullable(clazz.cast(streamName()));
        case "ShardCount":
            return Optional.ofNullable(clazz.cast(shardCount()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends KinesisRequest.Builder, CopyableBuilder<Builder, CreateStreamRequest> {
        /**
         * <p>
         * A name to identify the stream. The stream name is scoped to the AWS account used by the application that
         * creates the stream. It is also scoped by AWS Region. That is, two streams in two different AWS accounts can
         * have the same name. Two streams in the same AWS account but in two different Regions can also have the same
         * name.
         * </p>
         * 
         * @param streamName
         *        A name to identify the stream. The stream name is scoped to the AWS account used by the application
         *        that creates the stream. It is also scoped by AWS Region. That is, two streams in two different AWS
         *        accounts can have the same name. Two streams in the same AWS account but in two different Regions can
         *        also have the same name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamName(String streamName);

        /**
         * <p>
         * The number of shards that the stream will use. The throughput of the stream is a function of the number of
         * shards; more shards are required for greater provisioned throughput.
         * </p>
         * <p>
         * DefaultShardLimit;
         * </p>
         * 
         * @param shardCount
         *        The number of shards that the stream will use. The throughput of the stream is a function of the
         *        number of shards; more shards are required for greater provisioned throughput.</p>
         *        <p>
         *        DefaultShardLimit;
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shardCount(Integer shardCount);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KinesisRequest.BuilderImpl implements Builder {
        private String streamName;

        private Integer shardCount;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStreamRequest model) {
            super(model);
            streamName(model.streamName);
            shardCount(model.shardCount);
        }

        public final String getStreamName() {
            return streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        public final Integer getShardCount() {
            return shardCount;
        }

        @Override
        public final Builder shardCount(Integer shardCount) {
            this.shardCount = shardCount;
            return this;
        }

        public final void setShardCount(Integer shardCount) {
            this.shardCount = shardCount;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateStreamRequest build() {
            return new CreateStreamRequest(this);
        }
    }
}
