/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.kinesis.model.Consumer;

public class ConsumerUnmarshaller
implements Unmarshaller<Consumer, JsonUnmarshallerContext> {
    private static final ConsumerUnmarshaller INSTANCE = new ConsumerUnmarshaller();

    public Consumer unmarshall(JsonUnmarshallerContext context) throws Exception {
        Consumer.Builder consumerBuilder = Consumer.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("ConsumerName", targetDepth)) {
                    context.nextToken();
                    consumerBuilder.consumerName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ConsumerARN", targetDepth)) {
                    context.nextToken();
                    consumerBuilder.consumerARN((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ConsumerStatus", targetDepth)) {
                    context.nextToken();
                    consumerBuilder.consumerStatus((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ConsumerCreationTimestamp", targetDepth)) {
                    context.nextToken();
                    consumerBuilder.consumerCreationTimestamp((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Consumer)consumerBuilder.build();
    }

    public static ConsumerUnmarshaller getInstance() {
        return INSTANCE;
    }
}

