/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesis.transform;

import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.kinesis.model.SubscribeToShardEvent;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link SubscribeToShardEvent} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class SubscribeToShardEventMarshaller {
    private static final MarshallingInfo<List> RECORDS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Records").isBinary(false).build();

    private static final MarshallingInfo<String> CONTINUATIONSEQUENCENUMBER_BINDING = MarshallingInfo
            .builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("ContinuationSequenceNumber").isBinary(false).build();

    private static final MarshallingInfo<Long> MILLISBEHINDLATEST_BINDING = MarshallingInfo.builder(MarshallingType.LONG)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MillisBehindLatest").isBinary(false).build();

    private static final SubscribeToShardEventMarshaller INSTANCE = new SubscribeToShardEventMarshaller();

    private SubscribeToShardEventMarshaller() {
    }

    public static SubscribeToShardEventMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(SubscribeToShardEvent subscribeToShardEvent, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(subscribeToShardEvent, "subscribeToShardEvent");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(subscribeToShardEvent.records(), RECORDS_BINDING);
            protocolMarshaller.marshall(subscribeToShardEvent.continuationSequenceNumber(), CONTINUATIONSEQUENCENUMBER_BINDING);
            protocolMarshaller.marshall(subscribeToShardEvent.millisBehindLatest(), MILLISBEHINDLATEST_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
