/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.kinesis.model.StartingPosition;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class StartingPositionMarshaller {
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Type").isBinary(false).build();
    private static final MarshallingInfo<String> SEQUENCENUMBER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SequenceNumber").isBinary(false).build();
    private static final MarshallingInfo<Instant> TIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Timestamp").isBinary(false).build();
    private static final StartingPositionMarshaller INSTANCE = new StartingPositionMarshaller();

    private StartingPositionMarshaller() {
    }

    public static StartingPositionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(StartingPosition startingPosition, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)startingPosition, (String)"startingPosition");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)startingPosition.typeAsString(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)startingPosition.sequenceNumber(), SEQUENCENUMBER_BINDING);
            protocolMarshaller.marshall((Object)startingPosition.timestamp(), TIMESTAMP_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

