/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.kinesis.KinesisClient;
import software.amazon.awssdk.services.kinesis.model.ListStreamConsumersRequest;
import software.amazon.awssdk.services.kinesis.model.ListStreamConsumersResponse;

public class ListStreamConsumersIterable
implements SdkIterable<ListStreamConsumersResponse> {
    private final KinesisClient client;
    private final ListStreamConsumersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListStreamConsumersIterable(KinesisClient client, ListStreamConsumersRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListStreamConsumersResponseFetcher();
    }

    public Iterator<ListStreamConsumersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final ListStreamConsumersIterable resume(ListStreamConsumersResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListStreamConsumersIterable(this.client, (ListStreamConsumersRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListStreamConsumersIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListStreamConsumersResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListStreamConsumersResponseFetcher
    implements SyncPageFetcher<ListStreamConsumersResponse> {
        private ListStreamConsumersResponseFetcher() {
        }

        public boolean hasNextPage(ListStreamConsumersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListStreamConsumersResponse nextPage(ListStreamConsumersResponse previousPage) {
            if (previousPage == null) {
                return ListStreamConsumersIterable.this.client.listStreamConsumers(ListStreamConsumersIterable.this.firstRequest);
            }
            return ListStreamConsumersIterable.this.client.listStreamConsumers((ListStreamConsumersRequest)((Object)ListStreamConsumersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

