/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesis.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input for <a>DisableEnhancedMonitoring</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DisableEnhancedMonitoringRequest extends KinesisRequest implements
        ToCopyableBuilder<DisableEnhancedMonitoringRequest.Builder, DisableEnhancedMonitoringRequest> {
    private static final SdkField<String> STREAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DisableEnhancedMonitoringRequest::streamName)).setter(setter(Builder::streamName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamName").build()).build();

    private static final SdkField<List<String>> SHARD_LEVEL_METRICS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DisableEnhancedMonitoringRequest::shardLevelMetricsAsStrings))
            .setter(setter(Builder::shardLevelMetricsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShardLevelMetrics").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_NAME_FIELD,
            SHARD_LEVEL_METRICS_FIELD));

    private final String streamName;

    private final List<String> shardLevelMetrics;

    private DisableEnhancedMonitoringRequest(BuilderImpl builder) {
        super(builder);
        this.streamName = builder.streamName;
        this.shardLevelMetrics = builder.shardLevelMetrics;
    }

    /**
     * <p>
     * The name of the Kinesis data stream for which to disable enhanced monitoring.
     * </p>
     * 
     * @return The name of the Kinesis data stream for which to disable enhanced monitoring.
     */
    public String streamName() {
        return streamName;
    }

    /**
     * <p>
     * List of shard-level metrics to disable.
     * </p>
     * <p>
     * The following are the valid shard-level metrics. The value "<code>ALL</code>" disables every metric.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>IncomingBytes</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IncomingRecords</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OutgoingBytes</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OutgoingRecords</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>WriteProvisionedThroughputExceeded</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ReadProvisionedThroughputExceeded</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IteratorAgeMilliseconds</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ALL</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/kinesis/latest/dev/monitoring-with-cloudwatch.html">Monitoring the Amazon
     * Kinesis Data Streams Service with Amazon CloudWatch</a> in the <i>Amazon Kinesis Data Streams Developer
     * Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return List of shard-level metrics to disable.</p>
     *         <p>
     *         The following are the valid shard-level metrics. The value "<code>ALL</code>" disables every metric.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>IncomingBytes</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IncomingRecords</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OutgoingBytes</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OutgoingRecords</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>WriteProvisionedThroughputExceeded</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ReadProvisionedThroughputExceeded</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IteratorAgeMilliseconds</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ALL</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a
     *         href="http://docs.aws.amazon.com/kinesis/latest/dev/monitoring-with-cloudwatch.html">Monitoring the
     *         Amazon Kinesis Data Streams Service with Amazon CloudWatch</a> in the <i>Amazon Kinesis Data Streams
     *         Developer Guide</i>.
     */
    public List<MetricsName> shardLevelMetrics() {
        return TypeConverter.convert(shardLevelMetrics, MetricsName::fromValue);
    }

    /**
     * <p>
     * List of shard-level metrics to disable.
     * </p>
     * <p>
     * The following are the valid shard-level metrics. The value "<code>ALL</code>" disables every metric.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>IncomingBytes</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IncomingRecords</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OutgoingBytes</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OutgoingRecords</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>WriteProvisionedThroughputExceeded</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ReadProvisionedThroughputExceeded</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IteratorAgeMilliseconds</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ALL</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/kinesis/latest/dev/monitoring-with-cloudwatch.html">Monitoring the Amazon
     * Kinesis Data Streams Service with Amazon CloudWatch</a> in the <i>Amazon Kinesis Data Streams Developer
     * Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return List of shard-level metrics to disable.</p>
     *         <p>
     *         The following are the valid shard-level metrics. The value "<code>ALL</code>" disables every metric.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>IncomingBytes</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IncomingRecords</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OutgoingBytes</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OutgoingRecords</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>WriteProvisionedThroughputExceeded</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ReadProvisionedThroughputExceeded</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IteratorAgeMilliseconds</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ALL</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a
     *         href="http://docs.aws.amazon.com/kinesis/latest/dev/monitoring-with-cloudwatch.html">Monitoring the
     *         Amazon Kinesis Data Streams Service with Amazon CloudWatch</a> in the <i>Amazon Kinesis Data Streams
     *         Developer Guide</i>.
     */
    public List<String> shardLevelMetricsAsStrings() {
        return shardLevelMetrics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(streamName());
        hashCode = 31 * hashCode + Objects.hashCode(shardLevelMetricsAsStrings());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisableEnhancedMonitoringRequest)) {
            return false;
        }
        DisableEnhancedMonitoringRequest other = (DisableEnhancedMonitoringRequest) obj;
        return Objects.equals(streamName(), other.streamName())
                && Objects.equals(shardLevelMetricsAsStrings(), other.shardLevelMetricsAsStrings());
    }

    @Override
    public String toString() {
        return ToString.builder("DisableEnhancedMonitoringRequest").add("StreamName", streamName())
                .add("ShardLevelMetrics", shardLevelMetricsAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StreamName":
            return Optional.ofNullable(clazz.cast(streamName()));
        case "ShardLevelMetrics":
            return Optional.ofNullable(clazz.cast(shardLevelMetricsAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DisableEnhancedMonitoringRequest, T> g) {
        return obj -> g.apply((DisableEnhancedMonitoringRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KinesisRequest.Builder, SdkPojo, CopyableBuilder<Builder, DisableEnhancedMonitoringRequest> {
        /**
         * <p>
         * The name of the Kinesis data stream for which to disable enhanced monitoring.
         * </p>
         * 
         * @param streamName
         *        The name of the Kinesis data stream for which to disable enhanced monitoring.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamName(String streamName);

        /**
         * <p>
         * List of shard-level metrics to disable.
         * </p>
         * <p>
         * The following are the valid shard-level metrics. The value "<code>ALL</code>" disables every metric.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>IncomingBytes</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IncomingRecords</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OutgoingBytes</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OutgoingRecords</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>WriteProvisionedThroughputExceeded</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ReadProvisionedThroughputExceeded</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IteratorAgeMilliseconds</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALL</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/kinesis/latest/dev/monitoring-with-cloudwatch.html">Monitoring the Amazon
         * Kinesis Data Streams Service with Amazon CloudWatch</a> in the <i>Amazon Kinesis Data Streams Developer
         * Guide</i>.
         * </p>
         * 
         * @param shardLevelMetrics
         *        List of shard-level metrics to disable.</p>
         *        <p>
         *        The following are the valid shard-level metrics. The value "<code>ALL</code>" disables every metric.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>IncomingBytes</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IncomingRecords</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OutgoingBytes</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OutgoingRecords</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>WriteProvisionedThroughputExceeded</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ReadProvisionedThroughputExceeded</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IteratorAgeMilliseconds</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALL</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a
         *        href="http://docs.aws.amazon.com/kinesis/latest/dev/monitoring-with-cloudwatch.html">Monitoring the
         *        Amazon Kinesis Data Streams Service with Amazon CloudWatch</a> in the <i>Amazon Kinesis Data Streams
         *        Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shardLevelMetricsWithStrings(Collection<String> shardLevelMetrics);

        /**
         * <p>
         * List of shard-level metrics to disable.
         * </p>
         * <p>
         * The following are the valid shard-level metrics. The value "<code>ALL</code>" disables every metric.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>IncomingBytes</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IncomingRecords</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OutgoingBytes</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OutgoingRecords</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>WriteProvisionedThroughputExceeded</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ReadProvisionedThroughputExceeded</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IteratorAgeMilliseconds</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALL</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/kinesis/latest/dev/monitoring-with-cloudwatch.html">Monitoring the Amazon
         * Kinesis Data Streams Service with Amazon CloudWatch</a> in the <i>Amazon Kinesis Data Streams Developer
         * Guide</i>.
         * </p>
         * 
         * @param shardLevelMetrics
         *        List of shard-level metrics to disable.</p>
         *        <p>
         *        The following are the valid shard-level metrics. The value "<code>ALL</code>" disables every metric.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>IncomingBytes</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IncomingRecords</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OutgoingBytes</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OutgoingRecords</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>WriteProvisionedThroughputExceeded</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ReadProvisionedThroughputExceeded</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IteratorAgeMilliseconds</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALL</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a
         *        href="http://docs.aws.amazon.com/kinesis/latest/dev/monitoring-with-cloudwatch.html">Monitoring the
         *        Amazon Kinesis Data Streams Service with Amazon CloudWatch</a> in the <i>Amazon Kinesis Data Streams
         *        Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shardLevelMetricsWithStrings(String... shardLevelMetrics);

        /**
         * <p>
         * List of shard-level metrics to disable.
         * </p>
         * <p>
         * The following are the valid shard-level metrics. The value "<code>ALL</code>" disables every metric.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>IncomingBytes</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IncomingRecords</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OutgoingBytes</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OutgoingRecords</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>WriteProvisionedThroughputExceeded</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ReadProvisionedThroughputExceeded</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IteratorAgeMilliseconds</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALL</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/kinesis/latest/dev/monitoring-with-cloudwatch.html">Monitoring the Amazon
         * Kinesis Data Streams Service with Amazon CloudWatch</a> in the <i>Amazon Kinesis Data Streams Developer
         * Guide</i>.
         * </p>
         * 
         * @param shardLevelMetrics
         *        List of shard-level metrics to disable.</p>
         *        <p>
         *        The following are the valid shard-level metrics. The value "<code>ALL</code>" disables every metric.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>IncomingBytes</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IncomingRecords</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OutgoingBytes</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OutgoingRecords</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>WriteProvisionedThroughputExceeded</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ReadProvisionedThroughputExceeded</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IteratorAgeMilliseconds</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALL</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a
         *        href="http://docs.aws.amazon.com/kinesis/latest/dev/monitoring-with-cloudwatch.html">Monitoring the
         *        Amazon Kinesis Data Streams Service with Amazon CloudWatch</a> in the <i>Amazon Kinesis Data Streams
         *        Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shardLevelMetrics(Collection<MetricsName> shardLevelMetrics);

        /**
         * <p>
         * List of shard-level metrics to disable.
         * </p>
         * <p>
         * The following are the valid shard-level metrics. The value "<code>ALL</code>" disables every metric.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>IncomingBytes</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IncomingRecords</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OutgoingBytes</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OutgoingRecords</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>WriteProvisionedThroughputExceeded</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ReadProvisionedThroughputExceeded</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IteratorAgeMilliseconds</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALL</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/kinesis/latest/dev/monitoring-with-cloudwatch.html">Monitoring the Amazon
         * Kinesis Data Streams Service with Amazon CloudWatch</a> in the <i>Amazon Kinesis Data Streams Developer
         * Guide</i>.
         * </p>
         * 
         * @param shardLevelMetrics
         *        List of shard-level metrics to disable.</p>
         *        <p>
         *        The following are the valid shard-level metrics. The value "<code>ALL</code>" disables every metric.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>IncomingBytes</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IncomingRecords</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OutgoingBytes</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OutgoingRecords</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>WriteProvisionedThroughputExceeded</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ReadProvisionedThroughputExceeded</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IteratorAgeMilliseconds</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALL</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a
         *        href="http://docs.aws.amazon.com/kinesis/latest/dev/monitoring-with-cloudwatch.html">Monitoring the
         *        Amazon Kinesis Data Streams Service with Amazon CloudWatch</a> in the <i>Amazon Kinesis Data Streams
         *        Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shardLevelMetrics(MetricsName... shardLevelMetrics);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KinesisRequest.BuilderImpl implements Builder {
        private String streamName;

        private List<String> shardLevelMetrics = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DisableEnhancedMonitoringRequest model) {
            super(model);
            streamName(model.streamName);
            shardLevelMetricsWithStrings(model.shardLevelMetrics);
        }

        public final String getStreamName() {
            return streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        public final Collection<String> getShardLevelMetrics() {
            return shardLevelMetrics;
        }

        @Override
        public final Builder shardLevelMetricsWithStrings(Collection<String> shardLevelMetrics) {
            this.shardLevelMetrics = MetricsNameListCopier.copy(shardLevelMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder shardLevelMetricsWithStrings(String... shardLevelMetrics) {
            shardLevelMetricsWithStrings(Arrays.asList(shardLevelMetrics));
            return this;
        }

        @Override
        public final Builder shardLevelMetrics(Collection<MetricsName> shardLevelMetrics) {
            this.shardLevelMetrics = MetricsNameListCopier.copyEnumToString(shardLevelMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder shardLevelMetrics(MetricsName... shardLevelMetrics) {
            shardLevelMetrics(Arrays.asList(shardLevelMetrics));
            return this;
        }

        public final void setShardLevelMetrics(Collection<String> shardLevelMetrics) {
            this.shardLevelMetrics = MetricsNameListCopier.copy(shardLevelMetrics);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DisableEnhancedMonitoringRequest build() {
            return new DisableEnhancedMonitoringRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
